/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.codeaction;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ModifyAnnotationProposal;

public abstract class InsertAnnotationAttributesQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(InsertAnnotationAttributesQuickFix.class.getName());
    private static final String CODE_ACTION_LABEL = "Insert ''{0}'' attribute{1} to @{2}";
    private final String annotation;
    private final String[] attributes;

    public InsertAnnotationAttributesQuickFix(String annotation, String ... attributes) {
        this.annotation = annotation;
        this.attributes = attributes;
    }

    @Override
    public String getParticipantId() {
        return InsertAnnotationAttributesQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<ExtendedCodeAction> codeActions = new ArrayList<ExtendedCodeAction>();
        String name = this.getLabel(this.annotation, this.attributes);
        ExtendedCodeAction codeAction = new ExtendedCodeAction(name);
        codeAction.setRelevance(0);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), null, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), this.getCodeActionId()));
        codeActions.add(codeAction);
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        String label = this.getLabel(this.annotation, this.attributes);
        ASTNode node = context.getCoveringNode();
        IBinding parentType = this.getBinding(node);
        ModifyAnnotationProposal proposal = new ModifyAnnotationProposal(label, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, Arrays.asList(this.attributes), this.annotation);
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to resolve code action edit for inserting an anotation with attributes", e);
        }
        return toResolve;
    }

    protected abstract ICodeActionId getCodeActionId();

    protected String getLabel(String annotation, String[] attributes) {
        String[] parts = annotation.split("\\.");
        String AnnotationName = parts.length > 1 ? parts[parts.length - 1] : annotation;
        String atributeNames = String.join((CharSequence)",", attributes);
        String pluralSuffix = attributes.length > 1 ? "s" : "";
        return MessageFormat.format(CODE_ACTION_LABEL, atributeNames, pluralSuffix, AnnotationName);
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }
}

