/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.engine.python.ui.handlers;

import jakarta.inject.Named;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Evaluate;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.lsat.engine.python.ui.handlers.ExecutionEngineGeneratorDialog;
import org.eclipse.lsat.engine.python.ui.handlers.ExecutionEngineGeneratorJob;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExecutionEngineGeneratorHandler {
    @Evaluate
    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional IStructuredSelection selection) {
        boolean bl;
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object object = selection.getFirstElement();
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            bl = "dispatching".equals(file.getFileExtension());
        } else {
            bl = false;
        }
        return bl;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Named(value="activeShell") Shell shell) {
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return;
        }
        ExecutionEngineGeneratorDialog inputDialog = new ExecutionEngineGeneratorDialog(shell);
        if (inputDialog.open() == 1) {
            return;
        }
        IFile modelIFile = (IFile)selection.getFirstElement();
        IFolder saveIFolder = modelIFile.getProject().getFolder("src-gen");
        File saveFolder = saveIFolder.getLocation().toFile();
        ExecutionEngineGeneratorJob job = new ExecutionEngineGeneratorJob(modelIFile, saveFolder, inputDialog.isRemoveClaimAndReleases(), inputDialog.isSimulate());
        job.setUser(true);
        job.schedule();
    }
}

