/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.StringReader;
import org.apache.tomcat.util.collections.ConcurrentCache;
import org.apache.tomcat.util.http.parser.AstMediaType;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.ParseException;

public class MediaTypeCache {
    private final ConcurrentCache<String, String[]> cache;

    public MediaTypeCache(int size) {
        this.cache = new ConcurrentCache(size);
    }

    public String[] parse(String input) throws ParseException {
        String[] result = this.cache.get(input);
        if (result != null) {
            return result;
        }
        HttpParser hp = new HttpParser(new StringReader(input));
        AstMediaType m = hp.MediaType();
        result = new String[]{m.toStringNoCharset(), m.getCharset()};
        this.cache.put(input, result);
        return result;
    }
}

