/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.FileDirContext;

public class VirtualDirContext
extends FileDirContext {
    private String extraResourcePaths = "";
    private Map<String, List<String>> mappedResourcePaths;

    public void setExtraResourcePaths(String path) {
        this.extraResourcePaths = path;
    }

    @Override
    public void allocate() {
        super.allocate();
        this.mappedResourcePaths = new HashMap<String, List<String>>();
        StringTokenizer tkn = new StringTokenizer(this.extraResourcePaths, ",");
        while (tkn.hasMoreTokens()) {
            String path;
            String resSpec = tkn.nextToken();
            if (resSpec.length() <= 0) continue;
            int idx = resSpec.indexOf(61);
            if (idx <= 0) {
                path = "";
            } else {
                if (resSpec.startsWith("/=")) {
                    resSpec = resSpec.substring(1);
                    --idx;
                }
                path = resSpec.substring(0, idx);
            }
            String dir = resSpec.substring(idx + 1);
            List<String> resourcePaths = this.mappedResourcePaths.get(path);
            if (resourcePaths == null) {
                resourcePaths = new ArrayList<String>();
                this.mappedResourcePaths.put(path, resourcePaths);
            }
            resourcePaths.add(dir);
            this.setAllowLinking(true);
        }
        if (this.mappedResourcePaths.isEmpty()) {
            this.mappedResourcePaths = null;
        }
    }

    @Override
    public void release() {
        this.mappedResourcePaths = null;
        super.release();
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        try {
            Attributes attributes = super.getAttributes(name);
            return attributes;
        }
        catch (NamingException exc) {
            NamingException initialException = exc;
            if (this.mappedResourcePaths != null) {
                for (Map.Entry<String, List<String>> mapping : this.mappedResourcePaths.entrySet()) {
                    File f;
                    String path = mapping.getKey();
                    List<String> dirList = mapping.getValue();
                    String resourcesDir = dirList.get(0);
                    if (name.equals(path) && (f = new File(resourcesDir)).exists() && f.canRead()) {
                        return new FileDirContext.FileResourceAttributes(f);
                    }
                    if (!name.startsWith(path = path + "/")) continue;
                    String res = name.substring(path.length());
                    File f2 = new File(resourcesDir + "/" + res);
                    if (!f2.exists() || !f2.canRead()) continue;
                    return new FileDirContext.FileResourceAttributes(f2);
                }
            }
            throw initialException;
        }
    }

    @Override
    protected File file(String name) {
        File file = super.file(name);
        if (file != null || this.mappedResourcePaths == null) {
            return file;
        }
        if (name.length() > 0 && name.charAt(0) != '/') {
            name = "/" + name;
        }
        for (Map.Entry<String, List<String>> mapping : this.mappedResourcePaths.entrySet()) {
            String path = mapping.getKey();
            List<String> dirList = mapping.getValue();
            if (name.equals(path)) {
                for (String resourcesDir : dirList) {
                    file = new File(resourcesDir);
                    if (!file.exists() || !file.canRead()) continue;
                    return file;
                }
            }
            if (!name.startsWith(path + "/")) continue;
            String res = name.substring(path.length());
            for (String resourcesDir : dirList) {
                file = new File(resourcesDir, res);
                if (!file.exists() || !file.canRead()) continue;
                return file;
            }
        }
        return null;
    }

    @Override
    protected List<NamingEntry> list(File file) {
        List<NamingEntry> entries = super.list(file);
        if (this.mappedResourcePaths != null && !this.mappedResourcePaths.isEmpty()) {
            HashSet<String> entryNames = new HashSet<String>(entries.size());
            for (NamingEntry entry : entries) {
                entryNames.add(entry.name);
            }
            String absPath = file.getAbsolutePath();
            if (absPath.startsWith(this.getDocBase() + File.separator)) {
                String relPath = absPath.substring(this.getDocBase().length());
                String fsRelPath = relPath.replace(File.separatorChar, '/');
                for (Map.Entry<String, List<String>> mapping : this.mappedResourcePaths.entrySet()) {
                    String path = mapping.getKey();
                    List<String> dirList = mapping.getValue();
                    String res = null;
                    if (fsRelPath.equals(path)) {
                        res = "";
                    } else if (fsRelPath.startsWith(path + "/")) {
                        res = relPath.substring(path.length());
                    }
                    if (res == null) continue;
                    for (String resourcesDir : dirList) {
                        File f = new File(resourcesDir, res);
                        if (!f.exists() || !f.canRead() || !f.isDirectory()) continue;
                        List<NamingEntry> virtEntries = super.list(f);
                        for (NamingEntry entry : virtEntries) {
                            if (entryNames.contains(entry.name)) continue;
                            entryNames.add(entry.name);
                            entries.add(entry);
                        }
                    }
                }
            }
        }
        return entries;
    }

    @Override
    protected Object doLookup(String name) {
        Object retSuper = super.doLookup(name);
        if (retSuper != null || this.mappedResourcePaths == null) {
            return retSuper;
        }
        for (Map.Entry<String, List<String>> mapping : this.mappedResourcePaths.entrySet()) {
            String path = mapping.getKey();
            List<String> dirList = mapping.getValue();
            if (name.equals(path)) {
                for (String resourcesDir : dirList) {
                    File f = new File(resourcesDir);
                    if (!f.exists() || !f.canRead() || !f.isFile()) continue;
                    return new FileDirContext.FileResource(f);
                }
            }
            if (!name.startsWith(path = path + "/")) continue;
            String res = name.substring(path.length());
            for (String resourcesDir : dirList) {
                File f = new File(resourcesDir + "/" + res);
                if (!f.exists() || !f.canRead() || !f.isFile()) continue;
                return new FileDirContext.FileResource(f);
            }
        }
        return retSuper;
    }
}

