/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.domain.emf;

import java.util.Collection;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.domain.Activator;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.LoadableDomainHelper;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.LoadableDomain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EMFDomainHelper
extends LoadableDomainHelper {
    protected boolean doLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof EMFDomain) {
            EMFDomain myDomain = (EMFDomain)domain;
            myDomain.setLoaded(true);
            TargetPlatformResourceSet set = new TargetPlatformResourceSet();
            URI uri = myDomain.getUri();
            if (uri == null || "".equals(uri.toString())) {
                Activator.getDefault().logWarning(Messages.bind((String)Messages.Load_EMFDomain_error1, (Object)domain.getName()));
                return true;
            }
            Resource domainResource = null;
            try {
                domainResource = set.getResource(uri, true);
            }
            catch (Exception e) {
                throw new DomainException(Messages.bind((String)Messages.Load_EMFDomain_error2, (Object)uri.toString()), e);
            }
            if (!myDomain.getContent().isEmpty()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            myDomain.getContent().addAll((Collection)domainResource.getContents());
            return true;
        }
        return false;
    }

    protected boolean doUnLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof EMFDomain) {
            EMFDomain myDomain = (EMFDomain)domain;
            if (!myDomain.getContent().isEmpty()) {
                Resource eResource = ((EObject)myDomain.getContent().get(0)).eResource();
                if (eResource != null) {
                    eResource.unload();
                }
                myDomain.getContent().clear();
                myDomain.setLoaded(false);
            }
            return true;
        }
        return false;
    }
}

