/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import java.util.Arrays;

final class IntegerWriter {
    private static final int NEW = 0;
    private static final int CONFIGURED = 1;
    private static final int FIRST_BYTE_WRITTEN = 2;
    private static final int DONE = 4;
    private int state = 0;
    private int payload;
    private int N;
    private int value;

    IntegerWriter() {
    }

    public IntegerWriter configure(int n, int n2, int n3) {
        if (this.state != 0) {
            throw new IllegalStateException("Already configured");
        }
        if (n < 0) {
            throw new IllegalArgumentException("value >= 0: value=" + n);
        }
        IntegerWriter.checkPrefix(n2);
        this.value = n;
        this.N = n2;
        this.payload = n3 & 0xFF & -1 << n2;
        this.state = 1;
        return this;
    }

    public boolean write(ByteBuffer byteBuffer) {
        if (this.state == 0) {
            throw new IllegalStateException("Configure first");
        }
        if (this.state == 4) {
            return true;
        }
        if (!byteBuffer.hasRemaining()) {
            return false;
        }
        if (this.state == 1) {
            int n = (2 << this.N - 1) - 1;
            if (this.value < n) {
                byteBuffer.put((byte)(this.payload | this.value));
                this.state = 4;
                return true;
            }
            byteBuffer.put((byte)(this.payload | n));
            this.value -= n;
            this.state = 2;
        }
        if (this.state == 2) {
            while (this.value >= 128 && byteBuffer.hasRemaining()) {
                byteBuffer.put((byte)(this.value % 128 + 128));
                this.value /= 128;
            }
            if (!byteBuffer.hasRemaining()) {
                return false;
            }
            byteBuffer.put((byte)this.value);
            this.state = 4;
            return true;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.payload, this.N, this.value}));
    }

    private static void checkPrefix(int n) {
        if (n < 1 || n > 8) {
            throw new IllegalArgumentException("1 <= N <= 8: N= " + n);
        }
    }

    public IntegerWriter reset() {
        this.state = 0;
        return this;
    }
}

