/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import jdk.incubator.http.internal.common.ByteBufferPool;

public class ByteBufferReference
implements Supplier<ByteBuffer> {
    private ByteBuffer buffer;
    private final ByteBufferPool pool;

    public static ByteBufferReference of(ByteBuffer byteBuffer) {
        return ByteBufferReference.of(byteBuffer, null);
    }

    public static ByteBufferReference of(ByteBuffer byteBuffer, ByteBufferPool byteBufferPool) {
        Objects.requireNonNull(byteBuffer);
        return new ByteBufferReference(byteBuffer, byteBufferPool);
    }

    public static ByteBuffer[] toBuffers(ByteBufferReference ... byteBufferReferenceArray) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[byteBufferReferenceArray.length];
        for (int i = 0; i < byteBufferReferenceArray.length; ++i) {
            byteBufferArray[i] = byteBufferReferenceArray[i].get();
        }
        return byteBufferArray;
    }

    public static ByteBufferReference[] toReferences(ByteBuffer ... byteBufferArray) {
        ByteBufferReference[] byteBufferReferenceArray = new ByteBufferReference[byteBufferArray.length];
        for (int i = 0; i < byteBufferArray.length; ++i) {
            byteBufferReferenceArray[i] = ByteBufferReference.of(byteBufferArray[i]);
        }
        return byteBufferReferenceArray;
    }

    public static void clear(ByteBufferReference[] byteBufferReferenceArray) {
        for (ByteBufferReference byteBufferReference : byteBufferReferenceArray) {
            byteBufferReference.clear();
        }
    }

    private ByteBufferReference(ByteBuffer byteBuffer, ByteBufferPool byteBufferPool) {
        this.buffer = byteBuffer;
        this.pool = byteBufferPool;
    }

    @Override
    public ByteBuffer get() {
        ByteBuffer byteBuffer = this.buffer;
        assert (byteBuffer != null) : "getting ByteBuffer after clearance";
        return byteBuffer;
    }

    public void clear() {
        ByteBuffer byteBuffer = this.buffer;
        assert (byteBuffer != null) : "double ByteBuffer clearance";
        this.buffer = null;
        if (this.pool != null) {
            this.pool.release(byteBuffer);
        }
    }
}

