/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class RelationshipElement
extends PersistenceFieldElement {
    public static final int NONE_ACTION = 0;
    public static final int NULLIFY_ACTION = 1;
    public static final int RESTRICT_ACTION = 2;
    public static final int CASCADE_ACTION = 3;
    public static final int AGGREGATE_ACTION = 4;

    public RelationshipElement() {
        this(null, null);
    }

    public RelationshipElement(Impl impl, PersistenceClassElement declaringClass) {
        super(impl, declaringClass);
    }

    final Impl getRelationshipImpl() {
        return (Impl)this.getImpl();
    }

    public int getUpdateAction() {
        return this.getRelationshipImpl().getUpdateAction();
    }

    public void setUpdateAction(int action) throws ModelException {
        if (action < 0 || action > 4) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)RelationshipElement.getMessages(), (String)"jdo.relationship.update_action_invalid", (Object[])new Object[]{action}));
        }
        this.getRelationshipImpl().setUpdateAction(action);
    }

    public int getDeleteAction() {
        return this.getRelationshipImpl().getDeleteAction();
    }

    public void setDeleteAction(int action) throws ModelException {
        if (action < 0 || action > 4) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)RelationshipElement.getMessages(), (String)"jdo.relationship.delete_action_invalid", (Object[])new Object[]{action}));
        }
        this.getRelationshipImpl().setDeleteAction(action);
    }

    public boolean isPrefetch() {
        return this.getRelationshipImpl().isPrefetch();
    }

    public void setPrefetch(boolean flag) throws ModelException {
        this.getRelationshipImpl().setPrefetch(flag);
    }

    public int getLowerBound() {
        return this.getRelationshipImpl().getLowerBound();
    }

    public void setLowerBound(int lowerBound) throws ModelException {
        if (lowerBound > this.getUpperBound() || lowerBound < 0) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)RelationshipElement.getMessages(), (String)"jdo.relationship.lower_cardinality_invalid"));
        }
        this.getRelationshipImpl().setLowerBound(lowerBound);
    }

    public int getUpperBound() {
        return this.getRelationshipImpl().getUpperBound();
    }

    public void setUpperBound(int upperBound) throws ModelException {
        if (upperBound < this.getLowerBound() || upperBound <= 0) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)RelationshipElement.getMessages(), (String)"jdo.relationship.upper_cardinality_invalid"));
        }
        this.getRelationshipImpl().setUpperBound(upperBound);
    }

    public String getCollectionClass() {
        return this.getRelationshipImpl().getCollectionClass();
    }

    public void setCollectionClass(String collectionClass) throws ModelException {
        this.getRelationshipImpl().setCollectionClass(collectionClass);
    }

    public String getElementClass() {
        return this.getRelationshipImpl().getElementClass();
    }

    public void setElementClass(String elementClass) throws ModelException {
        this.getRelationshipImpl().setElementClass(elementClass);
    }

    public String getInverseRelationshipName() {
        return this.getRelationshipImpl().getInverseRelationshipName();
    }

    public RelationshipElement getInverseRelationship(Model model) {
        PersistenceClassElement relatedElement;
        String relatedClass;
        String inverseName = this.getInverseRelationshipName();
        RelationshipElement inverse = null;
        if (model != null && inverseName != null && (relatedClass = model.getRelatedClass(this)) != null && (relatedElement = model.getPersistenceClass(relatedClass)) != null) {
            inverse = relatedElement.getRelationship(inverseName);
        }
        return inverse;
    }

    public void setInverseRelationship(RelationshipElement inverseRelationship, Model model) throws ModelException {
        RelationshipElement old = this.getInverseRelationship(model);
        if (old != inverseRelationship || inverseRelationship == null && this.getInverseRelationshipName() != null) {
            RelationshipElement oldInverse;
            if (old != null && this.equals(oldInverse = old.getInverseRelationship(model))) {
                old.changeInverseRelationship(null);
            }
            this.changeInverseRelationship(inverseRelationship);
            if (inverseRelationship != null) {
                inverseRelationship.changeInverseRelationship(this);
            }
        }
    }

    public void changeInverseRelationship(RelationshipElement inverseRelationship) throws ModelException {
        this.getRelationshipImpl().changeInverseRelationship(inverseRelationship);
    }

    public static interface Impl
    extends PersistenceFieldElement.Impl {
        public int getUpdateAction();

        public void setUpdateAction(int var1) throws ModelException;

        public int getDeleteAction();

        public void setDeleteAction(int var1) throws ModelException;

        public boolean isPrefetch();

        public void setPrefetch(boolean var1) throws ModelException;

        public int getLowerBound();

        public void setLowerBound(int var1) throws ModelException;

        public int getUpperBound();

        public void setUpperBound(int var1) throws ModelException;

        public String getCollectionClass();

        public void setCollectionClass(String var1) throws ModelException;

        public String getElementClass();

        public void setElementClass(String var1) throws ModelException;

        public String getInverseRelationshipName();

        public void changeInverseRelationship(RelationshipElement var1) throws ModelException;
    }
}

