/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.NotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyIPServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQConnectionFilter;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQPacketDispatchFilter;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQPacketFilter;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyProtocolImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyService;
import com.sun.messaging.jmq.jmsserver.tlsutil.KeystoreUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.portunif.PUService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

public class GrizzlyIPService
extends IMQService
implements GrizzlyService,
NotificationInfo {
    private static boolean DEBUG = Globals.getLogger().getLevel() <= 4;
    protected PacketRouter router = null;
    private TCPNIOTransport transport = null;
    private GrizzlyProtocolImpl protocol = null;
    private TCPNIOServerConnection serverConn = null;
    private BrokerResources br = Globals.getBrokerResources();
    private GrizzlyExecutorService writerPool = null;
    private Object writeLock = new Object();
    private LinkedHashMap<ConnectionUID, GrizzlyMQIPConnection> pendingWrites = new LinkedHashMap();
    private boolean dedicatedWriter = Globals.getConfig().getBooleanProperty("imq.grizzlyIPService.dedicatedWriterThread", false);
    private AtomicInteger readerPoolThreadCnt = new AtomicInteger(0);
    private AtomicInteger writerPoolThreadCnt = new AtomicInteger(0);

    public GrizzlyIPService(String name, int type, PacketRouter router, int min, int max, GrizzlyIPServiceFactory parent) throws BrokerException {
        super(name, type);
        this.router = router;
        String ptypestr = "imq." + name + ".protocoltype";
        String p = Globals.getConfig().getProperty(ptypestr);
        if (p == null || !p.equals("tcp") && !p.equals("tls")) {
            throw new BrokerException("GrizzlyIPService: Not supported protocol: " + p);
        }
        String prefix = "imq.protocol." + p;
        String serviceprefix = "imq." + name + "." + p;
        try {
            Map params = parent.getProtocolParams(p, serviceprefix);
            params.put("serviceFactoryHandlerName", parent.getFactoryHandlerName());
            this.protocol = new GrizzlyProtocolImpl(this, p);
            this.protocol.checkParameters(params);
            this.protocol.setParameters(params);
            this.protocol.setMinMaxThreads(min, max, this.getName());
            boolean nodelay = Globals.getConfig().getBooleanProperty(prefix + ".nodelay", true);
            this.protocol.setNoDelay(nodelay);
            int inputBufferSize = Globals.getConfig().getIntProperty(prefix + ".inbufsz", 0);
            int outputBufferSize = Globals.getConfig().getIntProperty(prefix + ".outbufsz", 0);
            this.protocol.setInputBufferSize(inputBufferSize);
            this.protocol.setOutputBufferSize(outputBufferSize);
            String pname = "MQ-writer-thread-pool[" + this.getName() + "]";
            ThreadPoolConfig wpc = ThreadPoolConfig.defaultConfig().copy().setPoolName(pname).setCorePoolSize(this.protocol.getMinThreads()).setMaxPoolSize(this.protocol.getMaxThreads());
            wpc.getInitialMonitoringConfig().addProbes((Object[])new ThreadPoolProbe[]{new ThreadPoolProbeImpl(pname, this.writerPoolThreadCnt)});
            this.writerPool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)wpc);
            pname = "MQ-reader-thread-pool[" + this.getName() + "]";
            ThreadPoolConfig rpc = ThreadPoolConfig.defaultConfig().copy().setPoolName(pname).setCorePoolSize(this.protocol.getMinThreads()).setMaxPoolSize(this.protocol.getMaxThreads());
            rpc.getInitialMonitoringConfig().addProbes((Object[])new ThreadPoolProbe[]{new ThreadPoolProbeImpl(pname, this.readerPoolThreadCnt)});
            GrizzlyExecutorService pool = GrizzlyExecutorService.createInstance((ThreadPoolConfig)rpc);
            FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
            filterChainBuilder.add((Filter)new TransportFilter());
            if (p.equals("tls")) {
                SSLEngineConfigurator serverConfig = GrizzlyIPService.initializeSSL(name, this.protocol);
                SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
                filterChainBuilder.add((Filter)new SSLFilter(serverConfig, clientConfig));
            }
            filterChainBuilder.add((Filter)new GrizzlyMQConnectionFilter(this));
            filterChainBuilder.add((Filter)new GrizzlyMQPacketFilter());
            filterChainBuilder.add((Filter)new GrizzlyMQPacketDispatchFilter());
            TCPNIOTransportBuilder niobuilder = TCPNIOTransportBuilder.newInstance();
            ThreadPoolConfig tpc = ThreadPoolConfig.defaultConfig().setDaemon(false);
            niobuilder.setSelectorThreadPoolConfig(tpc);
            this.transport = niobuilder.build();
            this.transport.setReadBufferSize(this.protocol.getInputBufferSize());
            this.transport.setWriteBufferSize(this.protocol.getOutputBufferSize());
            this.transport.setWorkerThreadPool((ExecutorService)pool);
            this.transport.setProcessor((Processor)filterChainBuilder.build());
            this.bindTransport(false);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4386", name, e.getMessage());
            this.logger.logStack(32, emsg, e);
            try {
                if (this.serverConn != null) {
                    try {
                        this.serverConn.close();
                    }
                    catch (Exception inputBufferSize) {
                        // empty catch block
                    }
                    this.serverConn = null;
                }
                if (this.writerPool != null) {
                    this.writerPool.shutdown();
                }
                if (this.transport != null) {
                    this.transport.stop();
                }
            }
            catch (IOException e1) {
                this.logger.logStack(16, "Unable to stop transport after bind failure", e1);
            }
            throw new BrokerException(emsg);
        }
    }

    protected boolean useDedicatedWriter() {
        return this.dedicatedWriter;
    }

    private void unbindTransport() throws Exception {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.unbindTransport() for service " + this.name);
        }
        if (this.serverConn != null) {
            try {
                this.serverConn.preClose();
                this.serverConn.close();
            }
            catch (Exception e) {
                this.logger.logStack(16, "Exception closing server socket connection for service " + this.getName(), e);
            }
            this.serverConn = null;
            this.transport.unbindAll();
            this.logger.log(8, this.br.getKString("B1489", this.getName() + "[" + this.protocol.getType() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindTransport(boolean checkpause) throws Exception {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.bindTransport(" + checkpause + ") for service " + this.name);
        }
        this.unbindTransport();
        this.transport.setReuseAddress(true);
        this.transport.setTcpNoDelay(this.protocol.getNoDelay());
        int v = this.protocol.getTimeout();
        if (v > 0) {
            this.transport.setServerSocketSoTimeout(v * 1000);
        }
        if ((v = this.protocol.getLingerTimeout()) > 0) {
            this.transport.setLinger(v * 1000);
        }
        String hostn = this.protocol.getHostName();
        int portn = this.protocol.getPort();
        int backlog = this.protocol.getBacklog();
        this.logger.log(8, this.br.getKString("B1488", this.getName() + "[" + this.protocol.getType() + ", " + (hostn == null ? "*" : hostn) + ", " + portn + "]"));
        if (this.getState() == 4) {
            this.transport.resume();
        }
        if (hostn == null) {
            this.serverConn = this.transport.bind((SocketAddress)new InetSocketAddress(portn), backlog);
        } else {
            this.serverConn = this.transport.bind(hostn, portn, backlog);
            this.addServiceProp("hostname", hostn);
        }
        int lportn = this.getLocalPort();
        this.logger.log(8, this.br.getKString("B1425", this.getName() + "[" + this.protocol.getType() + "]", (hostn == null ? "" : hostn) + ":" + lportn + "(" + portn + ")"));
        if (checkpause && (this.getState() == 4 || this.getState() == 8)) {
            try {
                this.unbindTransport();
            }
            finally {
                if (this.getState() == 4) {
                    this.transport.pause();
                }
            }
        }
        Globals.getPortMapper().addService(this.getName(), this.protocol.getType(), Globals.getConfig().getProperty("imq." + this.getName() + ".servicetype"), lportn, this.getServiceProperties());
    }

    public static SSLEngineConfigurator initializeSSL(String servicen, GrizzlyProtocolImpl proto) throws Exception {
        boolean reqcauth = proto.getRequireClientAuth();
        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1424", proto.getType() + "[ClientAuth=" + reqcauth + "]", servicen));
        Properties sslprops = KeystoreUtil.getDefaultSSLContextConfig(servicen, null);
        SSLContextConfigurator sslcf = new SSLContextConfigurator();
        sslcf.setKeyManagerFactoryAlgorithm(sslprops.getProperty("ssl.KeyManagerFactory.algorithm"));
        sslcf.setKeyStoreFile(sslprops.getProperty("javax.net.ssl.keyStore"));
        sslcf.setKeyStorePass(sslprops.getProperty("javax.net.ssl.trustStorePassword"));
        sslcf.setKeyStoreType(sslprops.getProperty("javax.net.ssl.keyStoreType"));
        sslcf.setTrustManagerFactoryAlgorithm(sslprops.getProperty("ssl.TrustManagerFactory.algorithm"));
        sslcf.setTrustStoreFile(sslprops.getProperty("javax.net.ssl.trustStore"));
        sslcf.setTrustStorePass(sslprops.getProperty("javax.net.ssl.trustStorePassword"));
        sslcf.setTrustStoreType(sslprops.getProperty("javax.net.ssl.trustStoreType"));
        sslcf.setSecurityProtocol(sslprops.getProperty("securesocket.protocol"));
        SSLEngineConfigurator ec = new SSLEngineConfigurator(sslcf.createSSLContext(), false, reqcauth, reqcauth);
        if (Globals.getPoodleFixEnabled()) {
            PUService.applyPoodleFix(ec, Globals.getKnownSSLEnabledProtocols("GrizzlyIPService[" + servicen + "]"), "GrizzlyIPService[" + servicen + "]");
        }
        return ec;
    }

    @Override
    public int getLocalPort() {
        TCPNIOServerConnection sc = this.serverConn;
        if (sc == null) {
            return 0;
        }
        return ((InetSocketAddress)sc.getLocalAddress()).getPort();
    }

    @Override
    public synchronized boolean isOpen() {
        return this.serverConn != null;
    }

    @Override
    public synchronized int getMinThreadpool() {
        return this.protocol.getMinThreads() * 2;
    }

    @Override
    public synchronized int getMaxThreadpool() {
        return this.protocol.getMaxThreads() * 2;
    }

    @Override
    public synchronized int getActiveThreadpool() {
        int cntr = this.readerPoolThreadCnt.get();
        int cntw = this.writerPoolThreadCnt.get();
        return cntr + cntw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] setMinMaxThreadpool(int min, int max) {
        ThreadPoolConfig pc;
        if (this.writerPool != null) {
            pc = this.writerPool.getConfiguration();
            pc.setMaxPoolSize(max);
            pc.setCorePoolSize(min);
            Object object = this.writeLock;
            synchronized (object) {
                if (this.writerPool.isShutdown()) {
                    throw new IllegalStateException("Service " + this.getName() + " is shutting down");
                }
            }
            this.writerPool.reconfigure(pc);
        }
        if (this.transport != null) {
            pc = this.transport.getWorkerThreadPoolConfig();
            pc.setMaxPoolSize(max);
            pc.setCorePoolSize(min);
            ((GrizzlyExecutorService)this.transport.getWorkerThreadPool()).reconfigure(pc);
        }
        return null;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public synchronized void startService(boolean startPaused) {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.startService(" + startPaused + ") for service " + this.getName());
        }
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to start service, already started.");
            return;
        }
        this.setState(2);
        try {
            if (startPaused) {
                this.unbindTransport();
            } else if (this.serverConn == null) {
                throw new IOException("No server connection");
            }
            this.transport.start();
            Object[] args = new String[]{this.getName(), this.getProtocol().toString(), String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
            String msg = this.br.getKString("B1004", args);
            this.logger.log(8, msg + "[Grizzly " + Grizzly.getDotedVersion() + "]");
            try {
                this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), this.getName());
            }
            catch (BrokerException e2) {
                this.logger.log(16, "B2135", (Object)this.getName(), e2.getMessage());
            }
            Globals.getPortMapper().addService(this.name, this.protocol.getType(), Globals.getConfig().getProperty("imq." + this.name + ".servicetype"), this.getLocalPort(), this.getServiceProperties());
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4387", this.name, e.getMessage());
            this.logger.logStack(32, emsg, e);
            try {
                if (this.serverConn != null) {
                    try {
                        this.serverConn.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.serverConn = null;
                }
                this.transport.stop();
            }
            catch (Exception e1) {
                this.logger.logStack(16, "Failed to stop transport after start failure", e1);
                this.setServiceRunning(false);
                return;
            }
        }
        if (startPaused) {
            try {
                this.setServiceRunning(false);
                this.setState(4);
            }
            catch (Exception e) {
                this.logger.logStack(32, this.br.getKString("B4384", this.getName() + "[" + String.valueOf(this.getProtocol()) + "]", e.getMessage()), e);
                this.stopService(true);
            }
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean all) {
        Connection con;
        List<Connection> cons;
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.stopService(" + all + ") for service " + this.getName());
        }
        GrizzlyIPService grizzlyIPService = this;
        synchronized (grizzlyIPService) {
            if (this.isShuttingDown()) {
                return;
            }
            Object[] strings = new String[]{this.getName(), this.getProtocol().toString()};
            if (all) {
                this.logger.log(8, "B1007", strings);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", strings);
            }
            this.setShuttingDown(true);
            try {
                this.unbindTransport();
            }
            catch (Exception ex) {
                this.logger.logStack(16, "Exception unbinding transport for service " + this.getName() + "[" + String.valueOf(this.getProtocol()) + "]", ex);
            }
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (int i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.stopConnection();
            }
        }
        cons = this;
        synchronized (cons) {
            this.setState(5);
        }
        if (!all) {
            return;
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (int i = cons.size() - 1; i >= 0; --i) {
                con = cons.get(i);
                con.destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        try {
            this.transport.stop();
        }
        catch (Exception e) {
            this.logger.logStack(16, "Exception stopping transport for service " + this.getName() + "[" + String.valueOf(this.getProtocol()) + "], ignoring since we are exiting", e);
        }
        Object e = this;
        synchronized (e) {
            this.setState(6);
        }
        if (this.writerPool != null) {
            e = this.writeLock;
            synchronized (e) {
                this.writerPool.shutdown();
            }
            long endtime = System.currentTimeMillis() + this.getDestroyWaitTime();
            Object i = this.writeLock;
            synchronized (i) {
                while (this.pendingWrites.size() > 0) {
                    try {
                        this.writeLock.wait(this.getDestroyWaitTime());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < endtime) continue;
                }
            }
            try {
                long remaining = endtime - System.currentTimeMillis();
                if (remaining > 0L) {
                    this.writerPool.awaitTermination(remaining, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e2) {
                this.logger.logStack(8, "Exception in waiting reader thread pool terminate on stopping service " + this.getName(), e2);
            }
        }
        if (DEBUG) {
            this.logger.log(8, "Stopped Service {0} with protocol {1} ", (Object)this.getName(), this.getProtocol());
        }
    }

    @Override
    public synchronized void stopNewConnections() throws IOException {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.stopNewConnections() for service " + this.getName());
        }
        if (this.getState() != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        try {
            this.unbindTransport();
        }
        catch (Exception e) {
            throw new IOException("Unable to unbind transport for service " + this.name, e);
        }
        this.setState(8);
        Globals.getPortMapper().updateServicePort(this.name, 0);
    }

    @Override
    public synchronized void startNewConnections() throws IOException {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.startNewConnections() for service " + this.getName());
        }
        if (this.getState() != 8 && this.getState() != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        try {
            this.bindTransport(false);
        }
        catch (Exception e) {
            throw new IOException("Unable to bind transport for service " + this.name, e);
        }
        this.setState(3);
        Globals.getPortMapper().updateServicePort(this.name, this.getProtocol().getLocalPort());
    }

    @Override
    public synchronized void pauseService(boolean all) {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.pauseService(" + all + ") for service " + this.getName());
        }
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to pause service " + this.name + ", not running.");
            return;
        }
        Object[] strings = new String[]{this.getName(), this.getProtocol().toString()};
        this.logger.log(4, "B1005", strings);
        try {
            this.stopNewConnections();
            this.transport.pause();
        }
        catch (Exception ex) {
            this.logger.logStack(16, Globals.getBrokerResources().getKString("B4384", this.getName() + "[" + String.valueOf(this.getProtocol()) + "]", ex.getMessage()), ex);
        }
        this.setState(4);
        this.setServiceRunning(false);
    }

    @Override
    public synchronized void resumeService() {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.resumeService() for service " + this.getName());
        }
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to resume service " + this.name + ", already running.");
            return;
        }
        Object[] strings = new String[]{this.getName(), this.getProtocol().toString()};
        this.logger.log(4, "B1006", strings);
        try {
            this.startNewConnections();
            this.transport.resume();
        }
        catch (Exception ex) {
            this.logger.logStack(16, Globals.getBrokerResources().getKString("B4385", this.getName() + "[" + String.valueOf(this.getProtocol()) + "]", ex.getMessage()), ex);
        }
        this.setServiceRunning(true);
        this.setState(3);
    }

    @Override
    public synchronized void updateService(int port, int min, int max) throws IOException, PropertyUpdateException, BrokerException {
        this.updateService(port, min, max, true);
    }

    protected synchronized void updateService(int port, int min, int max, boolean store) throws IOException, PropertyUpdateException, BrokerException {
        if (DEBUG) {
            this.logger.log(8, "GrizzlyIPService.updateService(" + port + ", " + min + ", " + max + ", " + store + ") for service " + this.getName());
        }
        Object[] args = new String[]{this.getName(), String.valueOf(port), String.valueOf(min), String.valueOf(max)};
        this.logger.log(8, "B1090", args);
        try {
            if (min > -1 || max > -1) {
                int[] rets = this.protocol.setMinMaxThreads(min, max, this.getName());
                this.setMinMaxThreadpool(this.protocol.getMinThreads(), this.protocol.getMaxThreads());
                if (store && rets != null) {
                    if (rets[0] > -1) {
                        Globals.getConfig().updateProperty("imq." + this.name + ".min_threads", String.valueOf(2 * this.protocol.getMinThreads()));
                    }
                    if (rets[1] > -1) {
                        Globals.getConfig().updateProperty("imq." + this.name + ".max_threads", String.valueOf(2 * this.protocol.getMaxThreads()));
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            String emsg = Globals.getBrokerResources().getKString("B4115", String.valueOf(min), String.valueOf(max)) + ": " + e.getMessage();
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        if (port > -1) {
            boolean dostore = store;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("port", String.valueOf(port));
            this.protocol.checkParameters(params);
            Map oldparams = this.protocol.setParameters(params);
            if (oldparams != null) {
                Globals.getPortMapper().removeService(this.name);
                try {
                    this.bindTransport(true);
                }
                catch (Exception e) {
                    dostore = false;
                    String emsg = this.br.getKString("B4388", this.getName(), e.getMessage());
                    this.logger.logStack(32, emsg, e);
                    this.protocol.setParameters(oldparams);
                    Globals.getPortMapper().removeService(this.name);
                    try {
                        this.bindTransport(true);
                    }
                    catch (Exception ee) {
                        emsg = this.br.getKString("B4388", this.getName(), e.getMessage());
                        this.logger.logStack(32, emsg, ee);
                        throw new BrokerException(emsg, ee);
                    }
                }
            }
            if (dostore) {
                Globals.getConfig().updateProperty("imq." + this.name + "." + this.protocol.getType() + ".port", String.valueOf(port));
            }
        }
    }

    public GrizzlyMQIPConnection createConnection(org.glassfish.grizzly.Connection c) throws IOException, BrokerException {
        return new GrizzlyMQIPConnection(this, this.router, c);
    }

    @Override
    public void setReadyToWrite(IMQConnection con, boolean ready) {
        this.setReadyToWrite(con, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReadyToWrite(IMQConnection con, Exception exception) {
        block9: {
            if (this.dedicatedWriter) {
                return;
            }
            GrizzlyMQIPConnection pc = (GrizzlyMQIPConnection)con;
            boolean submit = false;
            Object object = this.writeLock;
            synchronized (object) {
                this.pendingWrites.put(pc.getConnectionUID(), pc);
                if (pc.assignWriteThread(true)) {
                    this.pendingWrites.remove(pc.getConnectionUID());
                    submit = true;
                    this.writeLock.notifyAll();
                }
            }
            if (!submit) {
                return;
            }
            final GrizzlyMQIPConnection c = pc;
            try {
                this.writerPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block32: {
                            int ret = 0;
                            try {
                                ret = c.writeData(false);
                            }
                            catch (Throwable t) {
                                try {
                                    c.handleWriteException(t);
                                }
                                catch (Throwable e) {
                                    int loglevel = c.isValid() ? 16 : 8;
                                    1 v0 = this;
                                    if (!v0.c.getDEBUG()) {
                                        GrizzlyIPService.this.logger;
                                        if (loglevel != 16) break block32;
                                    }
                                    GrizzlyIPService.this.logger.logStack(loglevel, "Exception in writing data to connection " + String.valueOf(c) + " for service " + GrizzlyIPService.this.getName(), e);
                                }
                            }
                            finally {
                                c.assignWriteThread(false);
                                boolean resubmit = false;
                                switch (ret) {
                                    case 0: {
                                        resubmit = true;
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                }
                                Object object = GrizzlyIPService.this.writeLock;
                                synchronized (object) {
                                    if (GrizzlyIPService.this.pendingWrites.get(c.getConnectionUID()) != null) {
                                        resubmit = true;
                                    }
                                }
                                if (resubmit) {
                                    GrizzlyIPService.this.setReadyToWrite((IMQConnection)c, true);
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                c.assignWriteThread(false);
                if (exception != null) {
                    throw new RuntimeException(e.getMessage(), exception);
                }
                if (this.isShuttingDown()) break block9;
                this.setReadyToWrite((IMQConnection)c, e);
            }
        }
    }

    @Override
    public void assigned(IMQConnection con, int events) throws IllegalAccessException {
        throw new UnsupportedOperationException("Unsupported call GrizzlyIPServer.assigned()");
    }

    @Override
    public void released(IMQConnection con, int events) {
        throw new UnsupportedOperationException("Unsupported call GrizzlyIPServer.assigned()");
    }

    @Override
    public void destroy(String reason) {
    }

    @Override
    public void dumpState() {
        this.logger.log(8, this.getStateInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStateInfo() {
        Object object = this.writeLock;
        synchronized (object) {
            return "GrizzlyIPService[" + this.getName() + "]pendingWriteCount: " + this.pendingWrites.size() + "\nGrizzlyIPService[" + this.getName() + "]writerPoolQueueSize: " + this.writerPool.getConfiguration().getQueue().size();
        }
    }

    class ThreadPoolProbeImpl
    implements ThreadPoolProbe {
        private String pname = null;
        private AtomicInteger counter = null;

        ThreadPoolProbeImpl(String pname, AtomicInteger counter) {
            this.pname = pname;
            this.counter = counter;
        }

        public void onThreadPoolStartEvent(AbstractThreadPool threadPool) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] started, " + String.valueOf(threadPool));
            }
        }

        public void onThreadPoolStopEvent(AbstractThreadPool threadPool) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] stopped");
            }
        }

        public void onThreadAllocateEvent(AbstractThreadPool threadPool, Thread thread) {
            int cnt = this.counter.getAndIncrement();
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] thread allocated[" + ++cnt + "]");
            }
        }

        public void onThreadReleaseEvent(AbstractThreadPool threadPool, Thread thread) {
            int cnt = this.counter.getAndDecrement();
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] thread released[" + --cnt + "]");
            }
        }

        public void onMaxNumberOfThreadsEvent(AbstractThreadPool threadPool, int maxNumberOfThreads) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(8, "ThreadPool[" + this.pname + "] threads max " + maxNumberOfThreads + " reached");
            }
        }

        public void onTaskQueueEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task queue event:" + String.valueOf(task));
            }
        }

        public void onTaskDequeueEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task dequeue event:" + String.valueOf(task));
            }
        }

        public void onTaskCompleteEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task complete event:" + String.valueOf(task));
            }
        }

        public void onTaskQueueOverflowEvent(AbstractThreadPool threadPool) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task queue overflow event");
            }
        }

        public void onTaskCancelEvent(AbstractThreadPool threadPool, Runnable task) {
            if (DEBUG) {
                Logger logger = GrizzlyIPService.this.logger;
                GrizzlyIPService.this.logger;
                logger.log(1, "ThreadPool[" + this.pname + "] task canceled event");
            }
        }
    }
}

