/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenEdDSA;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.SignatureEdDSA;
import com.jcraft.jsch.Util;
import java.util.Arrays;

abstract class KeyPairEdDSA
extends KeyPair {
    private byte[] pub_array;
    private byte[] prv_array;

    KeyPairEdDSA(JSch.InstanceLogger instLogger, byte[] pub_array, byte[] prv_array) {
        super(instLogger);
        this.pub_array = pub_array;
        this.prv_array = prv_array;
    }

    abstract String getSshName();

    abstract String getJceName();

    @Override
    void generate(int key_size) throws JSchException {
        try {
            Class<KeyPairGenEdDSA> c = Class.forName(JSch.getConfig("keypairgen.eddsa")).asSubclass(KeyPairGenEdDSA.class);
            KeyPairGenEdDSA keypairgen = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            keypairgen.init(this.getJceName(), this.getKeySize());
            this.pub_array = keypairgen.getPub();
            this.prv_array = keypairgen.getPrv();
            Object var3_4 = null;
        }
        catch (Exception | LinkageError e) {
            throw new JSchException(e.toString(), e);
        }
    }

    @Override
    byte[] getBegin() {
        throw new UnsupportedOperationException();
    }

    @Override
    byte[] getEnd() {
        throw new UnsupportedOperationException();
    }

    @Override
    byte[] getPrivateKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    byte[] getOpenSSHv1PrivateKeyBlob() {
        byte[] byArray;
        byte[] keyTypeName = this.getKeyTypeName();
        if (keyTypeName == null || this.pub_array == null || this.prv_array == null) {
            return null;
        }
        byte[] sk = null;
        Buffer _buf = null;
        try {
            sk = new byte[this.prv_array.length + this.pub_array.length];
            System.arraycopy(this.prv_array, 0, sk, 0, this.prv_array.length);
            System.arraycopy(this.pub_array, 0, sk, this.prv_array.length, this.pub_array.length);
            int _bufLen = 4 + keyTypeName.length;
            _bufLen += 4 + this.pub_array.length;
            _buf = new Buffer(_bufLen += 4 + sk.length);
            _buf.putString(keyTypeName);
            _buf.putString(this.pub_array);
            _buf.putString(sk);
            byArray = _buf.buffer;
        }
        catch (Exception e) {
            try {
                if (_buf != null) {
                    Util.bzero(_buf.buffer);
                }
                throw e;
            }
            catch (Throwable throwable) {
                Util.bzero(sk);
                throw throwable;
            }
        }
        Util.bzero(sk);
        return byArray;
    }

    @Override
    boolean parse(byte[] plain) {
        if (this.vendor == 2 || this.vendor == 5) {
            Buffer buf = new Buffer(plain);
            buf.skip(plain.length);
            try {
                byte[][] tmp = buf.getBytes(1, "");
                this.prv_array = tmp[0];
            }
            catch (JSchException e) {
                if (this.instLogger.getLogger().isEnabled(3)) {
                    this.instLogger.getLogger().log(3, "failed to parse key", e);
                }
                return false;
            }
            return true;
        }
        if (this.vendor == 4) {
            try {
                Buffer prvKeyBuffer = new Buffer(plain);
                int checkInt1 = prvKeyBuffer.getInt();
                int checkInt2 = prvKeyBuffer.getInt();
                if (checkInt1 != checkInt2) {
                    throw new JSchException("check failed");
                }
                String keyType = Util.byte2str(prvKeyBuffer.getString());
                this.pub_array = prvKeyBuffer.getString();
                byte[] tmp = prvKeyBuffer.getString();
                this.prv_array = Arrays.copyOf(tmp, this.getKeySize());
                this.publicKeyComment = Util.byte2str(prvKeyBuffer.getString());
                return true;
            }
            catch (Exception e) {
                if (this.instLogger.getLogger().isEnabled(3)) {
                    this.instLogger.getLogger().log(3, "failed to parse key", e);
                }
                return false;
            }
        }
        if (this.vendor == 3) {
            try {
                Class<KeyPairGenEdDSA> c = Class.forName(JSch.getConfig("keypairgen_fromprivate.eddsa")).asSubclass(KeyPairGenEdDSA.class);
                KeyPairGenEdDSA keypairgen = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                keypairgen.init(this.getJceName(), plain);
                this.pub_array = keypairgen.getPub();
                this.prv_array = keypairgen.getPrv();
                return true;
            }
            catch (Exception | LinkageError e) {
                if (this.instLogger.getLogger().isEnabled(3)) {
                    this.instLogger.getLogger().log(3, "failed to parse key", e);
                }
                return false;
            }
        }
        if (this.instLogger.getLogger().isEnabled(3)) {
            this.instLogger.getLogger().log(3, "failed to parse key");
        }
        return false;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        byte[] foo = super.getPublicKeyBlob();
        if (foo != null) {
            return foo;
        }
        if (this.pub_array == null) {
            return null;
        }
        byte[][] tmp = new byte[][]{this.getKeyTypeName(), this.pub_array};
        return Buffer.fromBytes((byte[][])tmp).buffer;
    }

    @Override
    byte[] getKeyTypeName() {
        return Util.str2byte(this.getSshName());
    }

    @Override
    public byte[] getSignature(byte[] data) {
        return this.getSignature(data, this.getSshName());
    }

    @Override
    public byte[] getSignature(byte[] data, String alg) {
        try {
            Class<SignatureEdDSA> c = Class.forName(JSch.getConfig(alg)).asSubclass(SignatureEdDSA.class);
            SignatureEdDSA eddsa = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            eddsa.init();
            eddsa.setPrvKey(this.prv_array);
            eddsa.update(data);
            byte[] sig = eddsa.sign();
            byte[][] tmp = new byte[][]{Util.str2byte(alg), sig};
            return Buffer.fromBytes((byte[][])tmp).buffer;
        }
        catch (Exception | LinkageError e) {
            if (this.instLogger.getLogger().isEnabled(3)) {
                this.instLogger.getLogger().log(3, "failed to generate signature", e);
            }
            return null;
        }
    }

    @Override
    public Signature getVerifier() {
        return this.getVerifier(this.getSshName());
    }

    @Override
    public Signature getVerifier(String alg) {
        try {
            Class<SignatureEdDSA> c = Class.forName(JSch.getConfig(alg)).asSubclass(SignatureEdDSA.class);
            SignatureEdDSA eddsa = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            eddsa.init();
            if (this.pub_array == null && this.getPublicKeyBlob() != null) {
                Buffer buf = new Buffer(this.getPublicKeyBlob());
                buf.getString();
                this.pub_array = buf.getString();
            }
            eddsa.setPubKey(this.pub_array);
            return eddsa;
        }
        catch (Exception | LinkageError e) {
            if (this.instLogger.getLogger().isEnabled(3)) {
                this.instLogger.getLogger().log(3, "failed to create verifier", e);
            }
            return null;
        }
    }

    @Override
    public byte[] forSSHAgent() throws JSchException {
        if (this.isEncrypted()) {
            throw new JSchException("key is encrypted.");
        }
        Buffer buf = new Buffer();
        buf.putString(this.getKeyTypeName());
        buf.putString(this.pub_array);
        byte[] tmp = new byte[this.prv_array.length + this.pub_array.length];
        System.arraycopy(this.prv_array, 0, tmp, 0, this.prv_array.length);
        System.arraycopy(this.pub_array, 0, tmp, this.prv_array.length, this.pub_array.length);
        buf.putString(tmp);
        buf.putString(Util.str2byte(this.publicKeyComment));
        byte[] result = new byte[buf.getLength()];
        buf.getByte(result, 0, result.length);
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

