/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationTarget;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.util.AnnotationOverrides;

abstract class AnnotationTargetImpl<Reflection extends AnnotatedElement>
implements AnnotationTarget {
    final Reflection reflection;
    final AnnotationOverrides overrides;
    protected final BeanManager bm;

    AnnotationTargetImpl(Reflection reflection, AnnotationOverrides overrides, BeanManager bm) {
        this.reflection = (AnnotatedElement)Objects.requireNonNull(reflection);
        this.overrides = overrides;
        this.bm = bm;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        AnnotationOverrides annotations = this.overrides != null ? this.overrides : this.reflection;
        return annotations.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        AnnotationOverrides annotations = this.overrides != null ? this.overrides : this.reflection;
        return Arrays.stream(annotations.getAnnotations()).anyMatch(it -> predicate.test(new AnnotationInfoImpl((Annotation)it, this.bm)));
    }

    @Override
    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        AnnotationOverrides annotations = this.overrides != null ? this.overrides : this.reflection;
        T annotation = annotations.getAnnotation(annotationType);
        return annotation == null ? null : new AnnotationInfoImpl((Annotation)annotation, this.bm);
    }

    @Override
    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        AnnotationOverrides annotations = this.overrides != null ? this.overrides : this.reflection;
        return Arrays.stream(annotations.getAnnotationsByType(annotationType)).map(t -> new AnnotationInfoImpl((Annotation)t, this.bm)).collect(Collectors.toList());
    }

    @Override
    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        AnnotationOverrides annotations = this.overrides != null ? this.overrides : this.reflection;
        return Arrays.stream(annotations.getAnnotations()).map(annotation -> new AnnotationInfoImpl((Annotation)annotation, this.bm)).filter(predicate).collect(Collectors.toList());
    }

    @Override
    public Collection<AnnotationInfo> annotations() {
        return this.annotations(it -> true);
    }
}

