/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import jakarta.ejb.Singleton;
import jakarta.ejb.Stateless;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.jersey.gf.ejb.internal.EjbClassUtilities;
import org.glassfish.jersey.gf.ejb.internal.EjbComponentProvider;

class EjbSupplier<T>
implements Supplier<T> {
    private static final Logger LOG = Logger.getLogger(EjbSupplier.class.getName());
    private final InitialContext ctx;
    private final Class<T> clazz;
    private final String beanName;
    private final EjbComponentProvider provider;

    EjbSupplier(Class<T> rawType, InitialContext ctx, EjbComponentProvider ejbProvider) {
        this.clazz = rawType;
        this.ctx = ctx;
        this.provider = ejbProvider;
        this.beanName = EjbSupplier.getBeanName(rawType);
    }

    @Override
    public T get() {
        try {
            return this.lookup(this.clazz, this.beanName);
        }
        catch (NamingException ex) {
            LOG.log(Level.SEVERE, "Could not find bean " + this.beanName + " of " + String.valueOf(this.clazz), ex);
            return null;
        }
    }

    private static <T> String getBeanName(Class<T> clazz) {
        Stateless stateless = clazz.getAnnotation(Stateless.class);
        if (stateless != null) {
            if (stateless.name().isEmpty()) {
                return clazz.getSimpleName();
            }
            return stateless.name();
        }
        Singleton singleton = clazz.getAnnotation(Singleton.class);
        if (singleton != null) {
            if (singleton.name().isEmpty()) {
                return clazz.getSimpleName();
            }
            return singleton.name();
        }
        return clazz.getSimpleName();
    }

    private T lookup(Class<T> rawType, String name) throws NamingException {
        try {
            return this.lookup(rawType, name, false);
        }
        catch (NamingException ex) {
            LOG.log(Level.WARNING, "An instance of EJB class, " + rawType.getName() + ", could not be looked up using simple form name. Attempting to look up using the fully-qualified form name.", ex);
            return this.lookup(rawType, name, true);
        }
    }

    private T lookup(Class<?> rawType, String name, boolean useRawTypeInJndiName) throws NamingException {
        List<String> libNames = this.provider.getModuleNames();
        if (libNames.isEmpty()) {
            String jndiName = EjbSupplier.toJndiName("java:module/", null, name, useRawTypeInJndiName ? rawType : null);
            return this.lookupTyped(jndiName);
        }
        NamingException exception = null;
        for (String module : libNames) {
            String jndiName = EjbSupplier.toJndiName("java:app/", module, name, useRawTypeInJndiName ? rawType : null);
            try {
                T result = this.lookupTyped(jndiName);
                if (result == null || !EjbSupplier.isLookupInstanceValid(rawType, result)) continue;
                return result;
            }
            catch (NamingException e) {
                exception = e;
            }
        }
        throw exception == null ? new NamingException("JNDI name " + name + " wasn't found in any of modules.") : exception;
    }

    private T lookupTyped(String name) throws NamingException {
        Object object = this.ctx.lookup(name);
        try {
            Object typed = object;
            return (T)typed;
        }
        catch (ClassCastException cause) {
            NamingException e = new NamingException("The name " + name + " was found, but the type is incorrect.");
            e.initCause(cause);
            throw e;
        }
    }

    private static String toJndiName(String prefix, String contextName, String name, Class<?> rawType) {
        StringBuilder jndiName = new StringBuilder(64);
        jndiName.append(prefix);
        if (contextName != null) {
            jndiName.append(contextName).append('/');
        }
        jndiName.append(name);
        if (rawType != null) {
            jndiName.append('!').append(rawType.getName());
        }
        return jndiName.toString();
    }

    private static boolean isLookupInstanceValid(Class<?> rawType, Object result) {
        return rawType.isInstance(result) || EjbClassUtilities.getRemoteAndLocalIfaces(rawType).stream().filter(iface -> iface.isInstance(result)).findAny().isPresent();
    }
}

