/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.Serializable;
import java.util.Enumeration;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;

final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient StandardContext context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;
    private boolean needInitialize = true;

    public ApplicationFilterConfig(StandardContext context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.context = context;
        this.setFilterDef(filterDef);
        try {
            this.getFilter();
        }
        catch (InstantiationException iex) {
            throw iex;
        }
        catch (Exception ex) {
            InstantiationException iex = new InstantiationException();
            iex.initCause(ex);
            throw iex;
        }
    }

    @Override
    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public boolean isAsyncSupported() {
        return this.filterDef.isAsyncSupported();
    }

    @Override
    public String getInitParameter(String name) {
        return this.filterDef.getInitParameter(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return this.filterDef.getInitParameterNames();
    }

    @Override
    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClassName());
        sb.append("]");
        return sb.toString();
    }

    synchronized Filter getFilter() throws Exception {
        if (this.filter != null && !this.needInitialize) {
            return this.filter;
        }
        if (this.filter == null) {
            Class<? extends Filter> clazz = this.filterDef.getFilterClass();
            if (clazz == null) {
                ClassLoader classLoader = null;
                String filterClassName = this.filterDef.getFilterClassName();
                classLoader = filterClassName.startsWith("org.apache.catalina.") ? this.getClass().getClassLoader() : this.context.getLoader().getClassLoader();
                clazz = this.loadFilterClass(classLoader, filterClassName);
            }
            this.filter = this.context.createFilterInstance(clazz);
        }
        if (this.context != null) {
            this.context.fireContainerEvent("beforeFilterInitialized", this.filter);
        }
        this.filter.init(this);
        this.needInitialize = false;
        if (this.context != null) {
            this.context.fireContainerEvent("afterFilterInitialized", this.filter);
        }
        return this.filter;
    }

    private Class<? extends Filter> loadFilterClass(ClassLoader classLoader, String filterClassName) throws ClassNotFoundException {
        return classLoader.loadClass(filterClassName);
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (this.filter != null) {
            if (this.context != null) {
                this.context.fireContainerEvent("beforeFilterDestroyed", this.filter);
            }
            this.filter.destroy();
            if (this.context != null) {
                this.context.fireContainerEvent("afterFilterDestroyed", this.filter);
                this.context = null;
            }
        }
        this.filter = null;
        this.needInitialize = true;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                this.filter.destroy();
            }
            this.filter = null;
        } else {
            this.filter = filterDef.getFilter();
        }
    }
}

