/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.invokable;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.invokable.CleanupActions;

class LookupUtils {
    private static final Map<Class<?>, Object> PRIMITIVE_WRAPPER_ZERO_VALUES = Map.ofEntries(Map.entry(Boolean.TYPE, false), Map.entry(Byte.TYPE, (byte)0), Map.entry(Short.TYPE, (short)0), Map.entry(Integer.TYPE, 0), Map.entry(Long.TYPE, 0L), Map.entry(Float.TYPE, Float.valueOf(0.0f)), Map.entry(Double.TYPE, 0.0), Map.entry(Character.TYPE, Character.valueOf('\u0000')));

    private LookupUtils() {
    }

    static boolean hasPrimitiveArgLookup(Class<?>[] types, boolean[] argLookup) {
        for (int i = 0; i < Math.min(types.length, argLookup.length); ++i) {
            if (!types[i].isPrimitive() || !argLookup[i]) continue;
            return true;
        }
        return false;
    }

    static Object[] replacePrimitiveLookupNulls(Object[] values, Class<?>[] types, boolean[] argLookup) {
        for (int i = 0; i < values.length; ++i) {
            Class<?> type = types[i];
            if (values[i] != null || !type.isPrimitive() || !argLookup[i]) continue;
            values[i] = PRIMITIVE_WRAPPER_ZERO_VALUES.get(type);
        }
        return values;
    }

    static Object lookup(CleanupActions cleanup, BeanManager beanManager, Type type, Annotation[] qualifiers) {
        WeldInstance lookup = (WeldInstance)beanManager.createInstance();
        Instance.Handle result = lookup.select(type, qualifiers).getHandle();
        cleanup.addInstanceHandle(result);
        return result.get();
    }

    static Annotation[] extractQualifiers(Collection<Annotation> annotations, BeanManager bm) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        for (Annotation a : annotations) {
            if (!bm.isQualifier(a.annotationType())) continue;
            qualifiers.add(a);
        }
        if (qualifiers.isEmpty() || qualifiers.size() == 1 && ((Annotation)qualifiers.get(0)).annotationType().equals(Named.class)) {
            qualifiers.add((Annotation)Default.Literal.INSTANCE);
        }
        return (Annotation[])qualifiers.toArray(Annotation[]::new);
    }
}

