/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime.service;

import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.DriverLoader;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JdbcAdminServiceImpl
extends ConnectorService {
    private static final String JDBC40_CONNECTION_VALIDATION = "org.glassfish.api.jdbc.validation.JDBC40ConnectionValidation";
    private static final JdbcAdminServiceImpl jdbcAdminService = new JdbcAdminServiceImpl();
    private final ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");
    @Inject
    private DriverLoader driverLoader;

    public static JdbcAdminServiceImpl getJdbcAdminService() {
        return jdbcAdminService;
    }

    public Set<String> getValidationClassNames(String className) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (className == null) {
            _logger.log(Level.WARNING, "jdbc.admin.service.ds_class_name_null");
            return classNames;
        }
        String dbVendor = this.driverLoader.getDatabaseVendorName(className);
        if (dbVendor == null) {
            return classNames;
        }
        Properties validationClassMappings = this.driverLoader.getValidationClassMappingFile();
        String validationClassName = validationClassMappings.getProperty(dbVendor);
        if (validationClassName != null) {
            classNames.add(validationClassName);
        }
        if (this.detectJDBC40(className)) {
            classNames.add(JDBC40_CONNECTION_VALIDATION);
        }
        return classNames;
    }

    private boolean detectJDBC40(String className) {
        boolean jdbc40 = true;
        ClassLoader commonClassLoader = ConnectorRuntime.getRuntime().getClassLoaderHierarchy().getCommonClassLoader();
        Class<?> cls = null;
        try {
            cls = commonClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
            return false;
        }
        try {
            Method method = cls.getMethod("isWrapperFor", Class.class);
            method.invoke(cls.newInstance(), DataSource.class);
        }
        catch (NoSuchMethodException e) {
            jdbc40 = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof AbstractMethodError) {
                jdbc40 = false;
            }
        }
        catch (InstantiationException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
            jdbc40 = false;
        }
        catch (IllegalAccessException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "jdbc.admin.service.ex_detect_jdbc40");
            }
            jdbc40 = false;
        }
        return jdbc40;
    }

    public Set<String> getValidationTableNames(PoolInfo poolInfo) throws ResourceException {
        ManagedConnectionFactory managedConnectionFactory = null;
        ManagedConnection managedConnection = null;
        Connection connection = null;
        try {
            managedConnection = (ManagedConnection)this.ccPoolAdmService.getUnpooledConnection(poolInfo, null, false);
            managedConnectionFactory = this.ccPoolAdmService.obtainManagedConnectionFactory(poolInfo);
            if (managedConnection != null) {
                connection = (Connection)managedConnection.getConnection(null, null);
            }
            Set<String> set = JdbcAdminServiceImpl.getValidationTableNames(connection, this.getDefaultDatabaseName(poolInfo, managedConnectionFactory));
            return set;
        }
        catch (Exception re) {
            _logger.log(Level.WARNING, "pool.get_validation_table_names_failure", re.getMessage());
            throw new ResourceException((Throwable)re);
        }
        finally {
            try {
                if (managedConnection != null) {
                    managedConnection.destroy();
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "pool.get_validation_table_names_mc_destroy", poolInfo);
            }
        }
    }

    private String getDefaultDatabaseName(PoolInfo poolInfo, ManagedConnectionFactory managedConnectionFactory) throws NamingException {
        String databaseName = null;
        ConnectorConnectionPool connectorConnectionPool = null;
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        connectorConnectionPool = (ConnectorConnectionPool)this._runtime.getResourceNamingService().lookup((GenericResourceInfo)poolInfo, jndiNameForPool, null);
        databaseName = this.ccPoolAdmService.getPropertyValue("DATABASENAME", connectorConnectionPool);
        if (databaseName == null || databaseName.trim().equals("")) {
            databaseName = ConnectionPoolObjectsUtils.getValueFromMCF("DatabaseName", poolInfo, managedConnectionFactory);
        }
        return databaseName;
    }

    public static Set<String> getValidationTableNames(Connection con, String catalog) throws ResourceException {
        TreeSet<String> treeSet;
        block12: {
            if (catalog.trim().isEmpty()) {
                catalog = null;
            }
            if (con == null) {
                throw new ResourceException("The connection is not valid as the connection is null");
            }
            DatabaseMetaData metaData = con.getMetaData();
            ResultSet rs = metaData.getTables(catalog, null, null, null);
            try {
                TreeSet<String> tableNames = new TreeSet<String>();
                while (rs.next()) {
                    String schemaName = rs.getString(2);
                    String tableName = rs.getString(3);
                    Object actualTableName = tableName;
                    if (schemaName != null && !schemaName.equals("")) {
                        actualTableName = schemaName + "." + tableName;
                    }
                    tableNames.add((String)actualTableName);
                }
                treeSet = tableNames;
                if (rs == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception sqle) {
                    _logger.log(Level.INFO, "pool.get_validation_table_names");
                    throw new ResourceException((Throwable)sqle);
                }
            }
            rs.close();
        }
        return treeSet;
    }
}

