/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.FileTransferCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileEndInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileListInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileStartInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;

class FileTransferRunnable
implements Runnable {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    Socket socket = null;
    BrokerAddressImpl remote = null;
    MessageDigest digest = null;
    int timeout = 0;
    ExecutorService es = null;
    ClusterImpl parent = null;

    FileTransferRunnable(Socket conn, int timeout, BrokerAddressImpl remote, ExecutorService es, ClusterImpl parent) throws BrokerException {
        this.socket = conn;
        this.remote = remote;
        this.timeout = timeout;
        this.es = es;
        this.parent = parent;
        try {
            this.digest = MessageDigest.getInstance("SHA1");
        }
        catch (Exception e) {
            es.shutdownNow();
            String emsg = "";
            if (e instanceof NoSuchAlgorithmException) {
                emsg = "Unable to create MessageDigest for file transfer";
                this.logger.log(32, emsg + ": " + String.valueOf(e));
            } else {
                emsg = "Unexpectd exception in creating MessageDigest for file transfer";
                this.logger.logStack(32, emsg, (Throwable)e);
            }
            throw new BrokerException(emsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String from = String.valueOf(this.remote) + "[" + String.valueOf(this.socket.getInetAddress()) + "]";
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (Exception e) {
            this.logger.log(16, "Failed to set socket TCP_NODELAY in processing file transfer request: " + String.valueOf(e));
        }
        try {
            this.socket.setSoTimeout(this.timeout);
        }
        catch (Exception e) {
            this.logger.log(16, "Failed to set socket timeout in processing file transfer request: " + String.valueOf(e));
        }
        try {
            OutputStream sos;
            InputStream is;
            block91: {
                String uuid;
                ClusterTransferFileListInfo tfl;
                GPacket gp;
                block94: {
                    block93: {
                        is = this.socket.getInputStream();
                        gp = GPacket.getInstance();
                        gp.read(is);
                        if (gp.getType() != 65) {
                            Object[] emsg = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), from, ProtocolGlobals.getPacketTypeDisplayString(65)};
                            this.logger.log(32, this.br.getKString("B3295", emsg));
                            try {
                                this.socket.close();
                                return;
                            }
                            catch (Exception exception) {
                                // empty catch block
                                return;
                            }
                        }
                        tfl = ClusterTransferFileListInfo.newInstance(gp);
                        uuid = tfl.getUUID();
                        String pendingUUID = this.parent.pendingFileTransfers.get(this.remote);
                        if (pendingUUID == null) break block93;
                        if (pendingUUID.startsWith(tfl.getUUID())) break block94;
                    }
                    this.logger.log(32, this.br.getKString("B3292", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + String.valueOf(tfl), this.remote));
                    try {
                        this.socket.close();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                        return;
                    }
                }
                if (!tfl.getModule().equals("store")) {
                    this.logger.log(32, this.br.getKString("B3287", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + tfl.toString(true), from));
                    try {
                        this.socket.close();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                        return;
                    }
                }
                FileTransferCallback callback = (FileTransferCallback)((Object)Globals.getStore());
                int numFiles = tfl.getNumFiles();
                for (int cnt = 0; cnt < numFiles; ++cnt) {
                    Object[] emsg;
                    if (this.parent.fileTransferShutdownIn) {
                        emsg = this.br.getKString("B2251");
                        this.logger.log(16, (String)emsg);
                        throw new BrokerException((String)emsg);
                    }
                    gp.read(is);
                    if (gp.getType() != 67) {
                        emsg = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), from, ProtocolGlobals.getPacketTypeDisplayString(67)};
                        this.logger.log(32, this.br.getKString("B3295", emsg));
                        try {
                            this.socket.close();
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                            return;
                        }
                    }
                    ClusterTransferFileStartInfo tfs = ClusterTransferFileStartInfo.newInstance(gp);
                    if (!tfs.getModule().equals("store")) {
                        this.logger.log(32, this.br.getKString("B3287", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + tfs.toString(true), from));
                        try {
                            this.socket.close();
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                            return;
                        }
                    }
                    if (!tfs.getBrokerID().equals(tfl.getBrokerID())) {
                        this.logger.log(32, this.br.getKString("B3287", ProtocolGlobals.getPacketTypeDisplayString(gp.getType()) + tfs.toString(true), from));
                        try {
                            this.socket.close();
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                            return;
                        }
                    }
                    String tmpfile = tfs.getFileName() + ".tmp";
                    ClusterTransferFileEndInfo fte = null;
                    boolean success = false;
                    FileOutputStream os = callback.getFileOutputStream(tmpfile, tfs.getBrokerID(), uuid, cnt == 0, this.remote);
                    try {
                        Object[] args;
                        this.digest.reset();
                        long size = tfs.getFileSize();
                        byte[] buf = new byte[8192];
                        int totalread = 0;
                        while ((long)totalread < size) {
                            if (this.parent.fileTransferShutdownIn) {
                                String emsg2 = this.br.getKString("B2251");
                                this.logger.log(16, emsg2);
                                throw new BrokerException(emsg2);
                            }
                            int count = 0;
                            try {
                                count = is.read(buf, 0, (int)Math.min(8192L, size - (long)totalread));
                            }
                            catch (IOException e) {
                                this.logger.log(32, this.br.getKString("B3289", from + ": " + String.valueOf(e)));
                                try {
                                    this.socket.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (!success) {
                                    try {
                                        ((OutputStream)os).close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    callback.doneTransfer(tmpfile, tfs.getFileName(), tfs.getBrokerID(), tfs.getLastModifiedTime(), false, this.remote);
                                }
                                this.es.shutdownNow();
                                return;
                            }
                            if (count < 0) {
                                args = new String[]{String.valueOf(totalread), String.valueOf(size - (long)totalread), from};
                                this.logger.log(32, this.br.getKString("B3290", args));
                                try {
                                    this.socket.close();
                                    return;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                    return;
                                }
                            }
                            totalread += count;
                            ((OutputStream)os).write(buf, 0, count);
                            this.digest.update(buf, 0, count);
                        }
                        args = new String[]{String.valueOf(size), tfs.getFileName(), from};
                        this.logger.log(8, this.br.getKString("B1401", args));
                        gp = GPacket.getInstance();
                        gp.read(is);
                        if (gp.getType() != 69) {
                            Object[] emsg3 = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), from, ProtocolGlobals.getPacketTypeDisplayString(69)};
                            this.logger.log(32, this.br.getKString("B3295", emsg3));
                            try {
                                this.socket.close();
                                return;
                            }
                            catch (Exception exception) {
                                // empty catch block
                                return;
                            }
                        }
                        fte = ClusterTransferFileEndInfo.newInstance(gp);
                        if (!Arrays.equals(this.digest.digest(), fte.getDigest())) {
                            this.logger.log(32, this.br.getKString("B3291", tfs.getFileName(), from));
                            try {
                                this.socket.close();
                                return;
                            }
                            catch (Exception exception) {
                                // empty catch block
                                return;
                            }
                        }
                        ((OutputStream)os).close();
                        this.logger.log(8, this.br.getKString("B1402", tfs.getFileName(), from));
                        callback.doneTransfer(tmpfile, tfs.getFileName(), tfs.getBrokerID(), tfs.getLastModifiedTime(), true, this.remote);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {}
                            callback.doneTransfer(tmpfile, tfs.getFileName(), tfs.getBrokerID(), tfs.getLastModifiedTime(), false, this.remote);
                        }
                    }
                    if (fte.hasMoreFiles() == cnt + 1 < numFiles) continue;
                    Object[] args = new String[]{String.valueOf(numFiles), from, String.valueOf(cnt + 1), String.valueOf(fte.hasMoreFiles())};
                    String emsg4 = this.br.getKString("B3296", args);
                    this.logger.log(32, emsg4);
                    throw new BrokerException(emsg4);
                }
                if (numFiles <= 0) return;
                callback.allDoneTransfer(tfl.getBrokerID(), tfl.getUUID(), this.remote);
                sos = this.socket.getOutputStream();
                gp = ClusterTransferFileEndInfo.getReplyGPacket(200, null);
                gp.write(sos);
                sos.flush();
                try {
                    gp = GPacket.getInstance();
                    gp.read(is);
                    if (gp.getType() != 71) {
                        Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gp.getType()), from, ProtocolGlobals.getPacketTypeDisplayString(71)};
                        String emsg = this.br.getKString("B3295", args);
                        this.logger.log(32, emsg);
                        throw new BrokerException(emsg);
                    }
                }
                catch (Throwable t) {
                    if (!ClusterImpl.DEBUG) break block91;
                    this.logger.log(8, "Exception in receiving " + ProtocolGlobals.getPacketTypeDisplayString(71) + " from " + from + " for tranfer files of broker " + tfl.getBrokerID() + ": " + t.getMessage());
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
                return;
            }
            catch (Exception exception) {
                // empty catch block
                return;
            }
        }
        catch (Throwable t) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.logStack(32, this.br.getKString("B3288", from), t);
            return;
        }
        finally {
            this.es.shutdownNow();
        }
    }
}

