/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import com.sun.webui.jsf.component.Wizard;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;

public final class WizardActionListener
implements ActionListener,
StateHolder {
    private String wizardId;
    private int event;
    private boolean isTransient = false;

    public WizardActionListener(String newWizardId, int newEvent) {
        this.wizardId = newWizardId;
        this.event = newEvent;
    }

    public WizardActionListener() {
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        Wizard wizard = Wizard.getWizard((UIComponent)actionEvent.getSource(), this.wizardId);
        if (wizard == null) {
            if (LogUtil.infoEnabled()) {
                LogUtil.info(WizardActionListener.class, "WEBUI0006", new String[]{this.wizardId});
            }
            throw new AbortProcessingException("Wizard parent not found processing " + this.event);
        }
        wizard.broadcastEvent((UIComponent)actionEvent.getSource(), this.event);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.event, this.wizardId, this.isTransient};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.event = (Integer)values[0];
        this.wizardId = (String)values[1];
        this.isTransient = (Boolean)values[2];
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

