/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.cdi.CDILoggerInfo;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.ejb.EjbDescriptorImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;

public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private static final Logger LOG = CDILoggerInfo.getLogger();
    private final ClassLoader moduleClassLoaderForBDA;
    private String id;
    private String friendlyId = "";
    private Collection<String> cdiAnnotatedClassNames;
    private boolean deploymentComplete;
    private final List<String> moduleClassNames;
    private final List<String> beanClassNames;
    private final List<Class<?>> moduleClasses;
    private final List<Class<?>> beanClasses;
    private final List<URL> beansXmlURLs;
    private final Collection<EjbDescriptor<?>> ejbDescImpls;
    private final List<BeanDeploymentArchive> beanDeploymentArchives;
    private SimpleServiceRegistry simpleServiceRegistry;
    private WeldUtils.BDAType bdaType = WeldUtils.BDAType.UNKNOWN;
    private final DeploymentContext context;
    private final Map<AnnotatedType<?>, InjectionTarget<?>> itMap = new HashMap();

    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this(archive, ejbs, ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx, String bdaID) {
        this.beanClasses = new ArrayList();
        this.beanClassNames = new ArrayList<String>();
        this.moduleClasses = new ArrayList();
        this.moduleClassNames = new ArrayList<String>();
        this.beansXmlURLs = new CopyOnWriteArrayList<URL>();
        this.id = bdaID == null ? archive.getName() : bdaID;
        this.friendlyId = this.id;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        try {
            this.populate(archive, ejbs);
            this.populateEJBsForThisBDA(ejbs);
        }
        finally {
            try {
                archive.close();
            }
            catch (Exception exception) {}
        }
        this.moduleClassLoaderForBDA = this.getClassLoader();
    }

    private void populateEJBsForThisBDA(Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        for (com.sun.enterprise.deployment.EjbDescriptor next : ejbs) {
            for (String className : this.moduleClassNames) {
                if (!className.equals(next.getEjbClassName())) continue;
                EjbDescriptorImpl wbEjbDesc = new EjbDescriptorImpl(next);
                this.ejbDescImpls.add(wbEjbDesc);
            }
        }
    }

    public BeanDeploymentArchiveImpl(String id, List<Class<?>> wClasses, List<URL> beansXmlUrls, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this.id = id;
        this.moduleClasses = wClasses;
        this.beanClasses = new ArrayList(wClasses);
        this.moduleClassNames = new ArrayList<String>();
        this.beanClassNames = new ArrayList<String>();
        for (Class<?> c : wClasses) {
            this.moduleClassNames.add(c.getName());
            this.beanClassNames.add(c.getName());
        }
        this.beansXmlURLs = beansXmlUrls;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        this.populateEJBsForThisBDA(ejbs);
        this.moduleClassLoaderForBDA = this.getClassLoader();
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public Collection<String> getBeanClasses() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "AS-CDI-00001", new Object[]{this.id, this.moduleClassLoaderForBDA});
        }
        if (!this.isDeploymentComplete()) {
            Thread.currentThread().setContextClassLoader(this.moduleClassLoaderForBDA);
        }
        return this.beanClassNames;
    }

    public Collection<Class<?>> getBeanClassObjects() {
        return this.beanClasses;
    }

    public Collection<String> getModuleBeanClasses() {
        return this.beanClassNames;
    }

    public Collection<Class<?>> getModuleBeanClassObjects() {
        return this.moduleClasses;
    }

    public void addBeanClass(String beanClassName) {
        boolean added = false;
        for (String moduleClassName : this.moduleClassNames) {
            if (!moduleClassName.equals(beanClassName)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "AS-CDI-00002", new Object[]{moduleClassName, this.beanClassNames});
            }
            this.beanClassNames.add(moduleClassName);
            try {
                this.beanClasses.add(this.getClassLoader().loadClass(moduleClassName));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            added = true;
        }
        if (!added && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00003", new Object[]{beanClassName});
        }
    }

    public Collection<String> getKnownClasses() {
        return this.moduleClassNames;
    }

    public BeansXml getBeansXml() {
        WeldBootstrap weldBootstrap = (WeldBootstrap)this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class);
        if (this.beansXmlURLs.size() == 1) {
            return weldBootstrap.parse(this.beansXmlURLs.get(0));
        }
        return weldBootstrap.parse(this.beansXmlURLs);
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbDescImpls;
    }

    public EjbDescriptor<?> getEjbDescriptor(String ejbName) {
        EjbDescriptor<?> match = null;
        for (EjbDescriptor<?> ejbDescriptor : this.ejbDescImpls) {
            if (!ejbDescriptor.getEjbName().equals(ejbName)) continue;
            match = ejbDescriptor;
            break;
        }
        return match;
    }

    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public String getId() {
        return this.id;
    }

    public String getFriendlyId() {
        return this.friendlyId;
    }

    public String toString() {
        String beanClassesString = this.getBeanClasses().size() > 0 ? this.getBeanClasses().toString() : "";
        String initVal = "|ID: " + this.getId() + ", bdaType= " + String.valueOf(this.bdaType) + ", accessibleBDAs #:" + this.getBeanDeploymentArchives().size() + ", " + this.formatAccessibleBDAs(this) + ", Bean Classes #: " + this.getBeanClasses().size() + "," + beanClassesString + ", ejbs=" + String.valueOf(this.getEjbs()) + "\n";
        StringBuilder valBuff = new StringBuilder(initVal);
        Collection<BeanDeploymentArchive> bdas = this.getBeanDeploymentArchives();
        for (BeanDeploymentArchive bda : bdas) {
            WeldUtils.BDAType embedBDAType = WeldUtils.BDAType.UNKNOWN;
            if (bda instanceof BeanDeploymentArchiveImpl) {
                embedBDAType = ((BeanDeploymentArchiveImpl)bda).getBDAType();
            }
            String embedBDABeanClasses = bda.getBeanClasses().size() > 0 ? bda.getBeanClasses().toString() : "";
            String val = "|---->ID: " + bda.getId() + ", bdaType= " + embedBDAType.toString() + ", accessibleBDAs #:" + bda.getBeanDeploymentArchives().size() + ", " + this.formatAccessibleBDAs(bda) + ", Bean Classes #: " + bda.getBeanClasses().size() + "," + embedBDABeanClasses + ", ejbs=" + String.valueOf(bda.getEjbs()) + "\n";
            valBuff.append(val);
        }
        return valBuff.toString();
    }

    private String formatAccessibleBDAs(BeanDeploymentArchive bda) {
        StringBuilder sb = new StringBuilder("[");
        for (BeanDeploymentArchive accessibleBDA : bda.getBeanDeploymentArchives()) {
            if (!(accessibleBDA instanceof BeanDeploymentArchiveImpl)) continue;
            sb.append(((BeanDeploymentArchiveImpl)accessibleBDA).getFriendlyId() + ",");
        }
        sb.append("]");
        return sb.toString();
    }

    public WeldUtils.BDAType getBDAType() {
        return this.bdaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        block40: {
            try {
                Enumeration entries;
                BeanDiscoveryMode bdMode;
                BeansXml beansXML;
                boolean webinfbda = false;
                boolean hasBeansXml = false;
                String beansXMLURL = null;
                if (archive.exists("WEB-INF/beans.xml")) {
                    beansXMLURL = "WEB-INF/beans.xml";
                }
                if (beansXMLURL == null && archive.exists("WEB-INF/classes/META-INF/beans.xml")) {
                    beansXMLURL = "WEB-INF/classes/META-INF/beans.xml";
                }
                if (beansXMLURL != null) {
                    beansXML = this.parseBeansXML(archive, beansXMLURL);
                    bdMode = beansXML.getBeanDiscoveryMode();
                    if (!bdMode.equals((Object)BeanDiscoveryMode.NONE)) {
                        webinfbda = true;
                        boolean bl = hasBeansXml = !bdMode.equals((Object)BeanDiscoveryMode.ANNOTATED);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "AS-CDI-00004", new Object[]{archive.getURI(), "WEB-INF/beans.xml", "WEB-INF/classes/META-INF/beans.xml"});
                        }
                    } else {
                        this.addBeansXMLURL(archive, beansXMLURL);
                    }
                } else if (archive.exists("WEB-INF/classes")) {
                    if (WeldUtils.hasExtension((ReadableArchive)archive)) {
                        this.bdaType = WeldUtils.BDAType.WAR;
                    } else {
                        URI webinfclasses = new File(this.context.getSourceDir().getAbsolutePath(), "WEB-INF/classes").toURI();
                        if (WeldUtils.isImplicitBeanArchive((DeploymentContext)this.context, (URI)webinfclasses)) {
                            webinfbda = true;
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "AS-CDI-00028", new Object[]{archive.getURI()});
                            }
                        }
                    }
                }
                if (webinfbda) {
                    this.bdaType = WeldUtils.BDAType.WAR;
                    entries = archive.entries();
                    while (entries.hasMoreElements()) {
                        String entry = (String)entries.nextElement();
                        if (this.legalClassName(entry)) {
                            if (entry.contains("WEB-INF/classes")) {
                                entry = entry.substring("WEB-INF/classes".length() + 1);
                            }
                            String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                            try {
                                if (hasBeansXml || this.isCDIAnnotatedClass(className)) {
                                    this.beanClassNames.add(className);
                                    this.beanClasses.add(this.getClassLoader().loadClass(className));
                                }
                                this.moduleClassNames.add(className);
                            }
                            catch (Throwable t) {
                                if (!LOG.isLoggable(Level.WARNING)) continue;
                                LOG.log(Level.WARNING, "AS-CDI-00005", new Object[]{className, t.toString()});
                            }
                            continue;
                        }
                        if (!entry.endsWith("beans.xml")) continue;
                        this.addBeansXMLURL(archive, entry);
                    }
                    archive.close();
                }
                if (archive.exists("WEB-INF/lib")) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "AS-CDI-00006", new Object[]{archive.getURI()});
                    }
                    this.bdaType = WeldUtils.BDAType.WAR;
                    entries = archive.entries("WEB-INF/lib");
                    ArrayList<ReadableArchive> weblibJarsThatAreBeanArchives = new ArrayList<ReadableArchive>();
                    while (entries.hasMoreElements()) {
                        String entry = (String)entries.nextElement();
                        if (!entry.endsWith(".jar") || entry.indexOf(47, "WEB-INF/lib".length() + 1) != -1) continue;
                        boolean closeArchive = true;
                        ReadableArchive weblibJarArchive = archive.getSubArchive(entry);
                        try {
                            if (weblibJarArchive.exists("META-INF/beans.xml")) {
                                BeansXml beansXML2 = this.parseBeansXML(weblibJarArchive, "META-INF/beans.xml");
                                BeanDiscoveryMode bdMode2 = beansXML2.getBeanDiscoveryMode();
                                if (bdMode2.equals((Object)BeanDiscoveryMode.NONE)) continue;
                                LOG.log(Level.FINE, "AS-CDI-00007", entry);
                                if (bdMode2.equals((Object)BeanDiscoveryMode.ANNOTATED) && !WeldUtils.isImplicitBeanArchive((DeploymentContext)this.context, (ReadableArchive)weblibJarArchive)) continue;
                                closeArchive = false;
                                weblibJarsThatAreBeanArchives.add(weblibJarArchive);
                                continue;
                            }
                            if (WeldUtils.isImplicitBeanArchive((DeploymentContext)this.context, (ReadableArchive)weblibJarArchive)) {
                                LOG.log(Level.FINE, "AS-CDI-00007", entry);
                                closeArchive = false;
                                weblibJarsThatAreBeanArchives.add(weblibJarArchive);
                                continue;
                            }
                            LOG.log(Level.FINE, "AS-CDI-00008", archive.getName());
                        }
                        finally {
                            if (!closeArchive) continue;
                            weblibJarArchive.close();
                        }
                    }
                    ArrayList<BeanDeploymentArchiveImpl> webLibBDAs = new ArrayList<BeanDeploymentArchiveImpl>();
                    if (!weblibJarsThatAreBeanArchives.isEmpty()) {
                        ListIterator libJarIterator = weblibJarsThatAreBeanArchives.listIterator();
                        while (libJarIterator.hasNext()) {
                            ReadableArchive libJarArchive = (ReadableArchive)libJarIterator.next();
                            BeanDeploymentArchiveImpl wlbda = new BeanDeploymentArchiveImpl(libJarArchive, ejbs, this.context, "WEB-INF/lib/" + libJarArchive.getName());
                            this.beanDeploymentArchives.add(wlbda);
                            webLibBDAs.add(wlbda);
                        }
                    }
                    this.ensureWebLibJarVisibility(webLibBDAs);
                    break block40;
                }
                if (archive.getName().endsWith(".rar") || archive.getName().endsWith("_rar")) {
                    this.bdaType = WeldUtils.BDAType.RAR;
                    this.collectRarInfo(archive);
                } else if (archive.exists("META-INF/beans.xml")) {
                    beansXML = this.parseBeansXML(archive, "META-INF/beans.xml");
                    bdMode = beansXML.getBeanDiscoveryMode();
                    if (!bdMode.equals((Object)BeanDiscoveryMode.NONE)) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "AS-CDI-00009", new Object[]{archive.getURI()});
                        }
                        this.bdaType = WeldUtils.BDAType.JAR;
                        this.collectJarInfo(archive, true, !bdMode.equals((Object)BeanDiscoveryMode.ANNOTATED));
                    } else {
                        this.addBeansXMLURL(archive, "META-INF/beans.xml");
                    }
                } else if (WeldUtils.isImplicitBeanArchive((DeploymentContext)this.context, (ReadableArchive)archive)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "AS-CDI-00029", new Object[]{archive.getURI()});
                    }
                    this.bdaType = WeldUtils.BDAType.JAR;
                    this.collectJarInfo(archive, true, false);
                }
            }
            catch (IOException | ClassNotFoundException cne) {
                LOG.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
            }
        }
    }

    private void ensureWebLibJarVisibility(List<BeanDeploymentArchiveImpl> webLibBDAs) {
        int i;
        for (i = 0; i < webLibBDAs.size(); ++i) {
            BeanDeploymentArchiveImpl firstBDA = webLibBDAs.get(i);
            boolean modified = false;
            for (BeanDeploymentArchiveImpl otherBDA : webLibBDAs) {
                if (firstBDA.getId().equals(otherBDA.getId())) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "AS-CDI-00030", new Object[]{firstBDA.getFriendlyId(), otherBDA.getFriendlyId()});
                }
                firstBDA.getBeanDeploymentArchives().add(otherBDA);
                modified = true;
            }
            if (!modified) continue;
            int idx = this.beanDeploymentArchives.indexOf(firstBDA);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "AS-CDI-00031", new Object[]{firstBDA.getFriendlyId()});
            }
            if (idx < 0) continue;
            this.beanDeploymentArchives.set(idx, firstBDA);
        }
        for (i = 0; i < webLibBDAs.size(); ++i) {
            int idx;
            BeanDeploymentArchiveImpl subBDA = webLibBDAs.get(i);
            subBDA.getBeanDeploymentArchives().add(this);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "AS-CDI-00032", new Object[]{subBDA.getId(), this.getId()});
            }
            if ((idx = this.beanDeploymentArchives.indexOf(subBDA)) < 0) continue;
            this.beanDeploymentArchives.set(idx, subBDA);
        }
    }

    private void collectJarInfo(ReadableArchive archive, boolean isBeanArchive, boolean hasBeansXml) throws IOException, ClassNotFoundException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-CDI-00013", new Object[]{archive.getURI()});
        }
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            this.handleEntry(archive, entry, isBeanArchive, hasBeansXml);
        }
    }

    private void handleEntry(ReadableArchive archive, String entry, boolean isBeanArchive, boolean hasBeansXml) {
        block14: {
            if (this.legalClassName(entry)) {
                String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                try {
                    if (isBeanArchive && (hasBeansXml || this.isCDIAnnotatedClass(className))) {
                        this.beanClasses.add(this.getClassLoader().loadClass(className));
                        this.beanClassNames.add(className);
                    }
                    this.moduleClassNames.add(className);
                }
                catch (Throwable t) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "AS-CDI-00005", new Object[]{className, t.toString()});
                    }
                    break block14;
                }
            }
            if (entry.endsWith("/beans.xml")) {
                try {
                    URL beansXmlUrl;
                    try (GlassfishUrlClassLoader classloader = new GlassfishUrlClassLoader("BeanXml", new URL[]{archive.getURI().toURL()}, null);){
                        beansXmlUrl = classloader.getResource(entry);
                    }
                    if (beansXmlUrl != null && !this.beansXmlURLs.contains(beansXmlUrl)) {
                        this.beansXmlURLs.add(beansXmlUrl);
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "AS-CDI-00033", e.getMessage());
                }
            }
        }
    }

    private boolean legalClassName(String className) {
        return className.endsWith(".class") && !className.startsWith("WEB-INF/lib");
    }

    private void collectRarInfo(ReadableArchive archive) throws IOException, ClassNotFoundException {
        LOG.log(Level.FINE, "AS-CDI-00015", archive.getURI());
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            if (entry.endsWith(".jar")) {
                ReadableArchive jarArchive = archive.getSubArchive(entry);
                try {
                    this.collectJarInfo(jarArchive, true, true);
                    continue;
                }
                finally {
                    if (jarArchive != null) {
                        jarArchive.close();
                    }
                    continue;
                }
            }
            this.handleEntry(archive, entry, true, true);
        }
    }

    private static String filenameToClassname(String filename) {
        String className = null;
        className = filename.indexOf(File.separatorChar) >= 0 ? filename.replace(File.separatorChar, '.') : filename.replace('/', '.');
        return className.substring(0, className.length() - 6);
    }

    private ClassLoader getClassLoader() {
        if (this.context.getClassLoader() != null) {
            return this.context.getClassLoader();
        }
        if (Thread.currentThread().getContextClassLoader() != null) {
            LOG.log(Level.FINEST, "Using TCL");
            return Thread.currentThread().getContextClassLoader();
        }
        LOG.log(Level.FINEST, "AS-CDI-00034");
        return BeanDeploymentArchiveImpl.class.getClassLoader();
    }

    public InjectionTarget<?> getInjectionTarget(AnnotatedType<?> annotatedType) {
        return this.itMap.get(annotatedType);
    }

    void putInjectionTarget(AnnotatedType<?> annotatedType, InjectionTarget<?> it) {
        this.itMap.put(annotatedType, it);
    }

    public ClassLoader getModuleClassLoaderForBDA() {
        return this.moduleClassLoaderForBDA;
    }

    private boolean isCDIAnnotatedClass(String className) {
        if (this.cdiAnnotatedClassNames == null) {
            this.cdiAnnotatedClassNames = WeldUtils.getCDIAnnotatedClassNames((DeploymentContext)this.context);
        }
        return this.cdiAnnotatedClassNames.contains(className);
    }

    protected BeansXml parseBeansXML(ReadableArchive archive, String beansXMLPath) throws IOException {
        WeldBootstrap weldBootstrap = (WeldBootstrap)this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class);
        return weldBootstrap.parse(this.getBeansXMLFileURL(archive, beansXMLPath));
    }

    private void addBeansXMLURL(ReadableArchive archive, String beansXMLPath) throws IOException {
        URL beansXmlUrl = this.getBeansXMLFileURL(archive, beansXMLPath);
        if (!this.beansXmlURLs.contains(beansXmlUrl)) {
            this.beansXmlURLs.add(beansXmlUrl);
        }
    }

    private URL getBeansXMLFileURL(ReadableArchive archive, String beansXMLPath) throws IOException {
        URL url = null;
        File file = new File(archive.getURI().getPath());
        if (file.isDirectory()) {
            file = new File(file, beansXMLPath);
            url = file.toURI().toURL();
        } else {
            url = new URL("jar:" + String.valueOf(file.toURI()) + "!/" + beansXMLPath);
        }
        return url;
    }

    public boolean isDeploymentComplete() {
        return this.deploymentComplete;
    }

    public void setDeploymentComplete(boolean deploymentComplete) {
        this.deploymentComplete = deploymentComplete;
    }
}

