/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import jakarta.faces.application.Application;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.FacesValidator;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidatorConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES = List.of(FacesValidator.class);
    private Map<ValidatorInfo, String> validators;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (this.validators == null) {
            this.validators = new HashMap<ValidatorInfo, String>();
        }
        FacesValidator validatorAnnotation = (FacesValidator)annotation;
        Object value = ((FacesValidator)annotation).value();
        if (null == value || 0 == ((String)value).length()) {
            value = target.getSimpleName();
            value = Character.toLowerCase(((String)value).charAt(0)) + ((String)value).substring(1);
        }
        ValidatorInfo info = new ValidatorInfo((String)value, validatorAnnotation.isDefault());
        this.validators.put(info, target.getName());
    }

    @Override
    public void push(FacesContext ctx) {
        if (this.validators != null) {
            Application app = ctx.getApplication();
            for (Map.Entry<ValidatorInfo, String> entry : this.validators.entrySet()) {
                app.addValidator(entry.getKey().validatorId, entry.getValue());
                if (!entry.getKey().isDefault) continue;
                app.addDefaultValidatorId(entry.getKey().validatorId);
            }
        }
    }

    private static class ValidatorInfo {
        final String validatorId;
        final boolean isDefault;

        ValidatorInfo(String validatorId, boolean isDefault) {
            this.validatorId = validatorId;
            this.isDefault = isDefault;
        }
    }
}

