/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.web;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.DirContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.naming.resources.WebDirContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.loader.LogFacade;
import org.glassfish.web.loader.WebappClassLoader;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="war")
public class WarHandler
extends AbstractArchiveHandler {
    private static final Logger LOG = LogFacade.getLogger();
    private static final ResourceBundle I18N = LOG.getResourceBundle();
    private static final String GLASSFISH_WEB_XML = "WEB-INF/glassfish-web.xml";
    private static final String SUN_WEB_XML = "WEB-INF/sun-web.xml";
    private static final String WEBLOGIC_XML = "WEB-INF/weblogic.xml";
    private static final String WAR_CONTEXT_XML = "META-INF/context.xml";
    private static final String DEFAULT_CONTEXT_XML = "config/context.xml";
    private static final boolean gfDDOverWLSDD = Boolean.valueOf(System.getProperty("gfdd.over.wlsdd"));
    private static final boolean ignoreWLSDD = Boolean.valueOf(System.getProperty("ignore.wlsdd"));
    @Inject
    @Named(value="war")
    private ArchiveDetector detector;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    @Inject
    private ServerEnvironment serverEnvironment;

    public String getArchiveType() {
        return "war";
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        try {
            return this.getWebXmlParser(archive).getVersionIdentifier();
        }
        catch (IOException | XMLStreamException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        WebappClassLoader cloader = new WebappClassLoader(parent);
        try {
            WebDirContext webDirContext = new WebDirContext();
            File base = new File(context.getSource().getURI());
            webDirContext.setDocBase(base.getAbsolutePath());
            cloader.setResources((DirContext)webDirContext);
            cloader.addRepository("WEB-INF/classes/", new File(base, "WEB-INF/classes/"));
            if (context.getScratchDir("ejb") != null) {
                cloader.addRepository(context.getScratchDir("ejb").toURI().toURL().toString().concat("/"));
            }
            if (context.getScratchDir("jsp") != null) {
                cloader.setWorkDir(context.getScratchDir("jsp"));
            }
            for (URL url : this.getManifestLibraries(context)) {
                cloader.addRepository(url.toString());
            }
            WebXmlParser webXmlParser = this.getWebXmlParser(context.getSource());
            this.configureLoaderAttributes(cloader, webXmlParser, base);
            this.configureLoaderProperties(cloader, webXmlParser, base);
            this.configureContextXmlAttribute(cloader, base, context);
        }
        catch (IOException | XMLStreamException xse) {
            LOG.log(Level.SEVERE, xse.getMessage(), xse);
        }
        cloader.start();
        return cloader;
    }

    protected WebXmlParser getWebXmlParser(ReadableArchive archive) throws XMLStreamException, IOException {
        boolean hasWSLDD = archive.exists(WEBLOGIC_XML);
        File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
        if (runtimeAltDDFile != null && "glassfish-web.xml".equals(runtimeAltDDFile.getPath()) && runtimeAltDDFile.isFile()) {
            return new GlassFishWebXmlParser(archive);
        }
        if (!gfDDOverWLSDD && !ignoreWLSDD && hasWSLDD) {
            return new WeblogicXmlParser(archive);
        }
        if (archive.exists(GLASSFISH_WEB_XML)) {
            return new GlassFishWebXmlParser(archive);
        }
        if (archive.exists(SUN_WEB_XML)) {
            return new SunWebXmlParser(archive);
        }
        if (gfDDOverWLSDD && !ignoreWLSDD && hasWSLDD) {
            return new WeblogicXmlParser(archive);
        }
        if (gfDDOverWLSDD || ignoreWLSDD) {
            return new GlassFishWebXmlParser(archive);
        }
        return new WeblogicXmlParser(archive);
    }

    protected void configureLoaderAttributes(WebappClassLoader cloader, WebXmlParser webXmlParser, File base) {
        String[] pathElements;
        String extraClassPath;
        boolean delegate = webXmlParser.isDelegate();
        cloader.setDelegate(delegate);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("WebModule[" + String.valueOf(base) + "]: Setting delegate to " + delegate);
        }
        if ((extraClassPath = webXmlParser.getExtraClassPath()) == null) {
            return;
        }
        for (String path : pathElements = extraClassPath.split(";|((?<!\\\\):)")) {
            path = path.replace("\\:", ":");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("WarHandler[" + String.valueOf(base) + "]: Adding " + path + " to the classpath");
            }
            try {
                new URL(path);
                cloader.addRepository(path);
            }
            catch (MalformedURLException mue1) {
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = new File(base.getPath(), path);
                }
                try {
                    URL url = file.toURI().toURL();
                    cloader.addRepository(url.toString());
                }
                catch (MalformedURLException mue2) {
                    String msg = I18N.getString("AS-WEB-UTIL-00027");
                    Object[] params = new Object[]{path};
                    msg = MessageFormat.format(msg, params);
                    LOG.log(Level.SEVERE, msg, mue2);
                }
            }
        }
    }

    protected void configureLoaderProperties(WebappClassLoader cloader, WebXmlParser webXmlParser, File base) {
        cloader.setUseMyFaces(webXmlParser.isUseBundledJSF());
        File libDir = new File(base, "WEB-INF/lib");
        if (!libDir.exists()) {
            return;
        }
        int baseFileLen = base.getPath().length();
        boolean ignoreHiddenJarFiles = webXmlParser.isIgnoreHiddenJarFiles();
        FileFilter fileFilter = pathname -> {
            String fileName = pathname.getName();
            return !(!fileName.endsWith(".jar") && !fileName.endsWith(".zip") || ignoreHiddenJarFiles && fileName.startsWith("."));
        };
        File[] files = libDir.listFiles(fileFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    cloader.addRepository("WEB-INF/lib/" + file.getName() + "/", file);
                    continue;
                }
                cloader.addJar(file.getPath().substring(baseFileLen), file);
            }
            catch (Exception e) {
                LOG.log(Level.FINEST, "Could not add file " + String.valueOf(file), e);
            }
        }
    }

    protected void configureContextXmlAttribute(WebappClassLoader cloader, File base, DeploymentContext dc) throws XMLStreamException, IOException {
        boolean consistent = true;
        Boolean value = null;
        File warContextXml = new File(base.getAbsolutePath(), WAR_CONTEXT_XML);
        if (warContextXml.exists()) {
            ContextXmlParser parser = new ContextXmlParser(warContextXml);
            value = parser.getClearReferencesStatic();
        }
        if (value == null) {
            Boolean domainCRS = null;
            File defaultContextXml = new File(this.serverEnvironment.getInstanceRoot(), DEFAULT_CONTEXT_XML);
            if (defaultContextXml.exists()) {
                ContextXmlParser parser = new ContextXmlParser(defaultContextXml);
                domainCRS = parser.getClearReferencesStatic();
            }
            ArrayList<Boolean> csrs = new ArrayList<Boolean>();
            HttpService httpService = this.serverConfig.getHttpService();
            DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            String vsIDs = params.virtualservers;
            List<String> vsList = StringUtils.parseStringList(vsIDs, " ,");
            if (httpService != null && vsList != null && !vsList.isEmpty()) {
                for (VirtualServer vsBean : httpService.getVirtualServer()) {
                    File contextXml;
                    if (!vsList.contains(vsBean.getId())) continue;
                    Boolean csr = null;
                    Property prop = vsBean.getProperty("contextXmlDefault");
                    if (prop != null && (contextXml = new File(this.serverEnvironment.getInstanceRoot(), prop.getValue())).exists()) {
                        ContextXmlParser parser = new ContextXmlParser(contextXml);
                        csr = parser.getClearReferencesStatic();
                    }
                    if (csr == null) {
                        csr = domainCRS;
                    }
                    csrs.add(csr);
                }
                for (Boolean b : csrs) {
                    if (b == null) continue;
                    if (value != null && !b.equals(value)) {
                        consistent = false;
                        break;
                    }
                    value = b;
                }
            }
        }
        if (consistent) {
            if (value != null) {
                cloader.setClearReferencesStatic(value);
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "AS-WEB-UTIL-00028");
        }
    }

    public List<URI> getClassPathURIs(ReadableArchive archive) {
        List uris = super.getClassPathURIs(archive);
        try {
            File archiveFile = new File(archive.getURI());
            if (archiveFile.exists() && archiveFile.isDirectory()) {
                uris.add(new URI(archive.getURI().toString() + "WEB-INF/classes/"));
                File webInf = new File(archiveFile, "WEB-INF");
                File webInfLib = new File(webInf, "lib");
                if (webInfLib.exists()) {
                    uris.addAll(ASClassLoaderUtil.getLibDirectoryJarURIs((File)webInfLib));
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        return uris;
    }

    protected abstract class WebXmlParser
    extends BaseXmlParser {
        protected boolean delegate;
        protected boolean ignoreHiddenJarFiles;
        protected boolean useBundledJSF;
        protected String extraClassPath;
        protected String versionIdentifier;

        WebXmlParser(ReadableArchive archive) throws XMLStreamException, IOException {
            this.delegate = true;
            this.ignoreHiddenJarFiles = false;
            this.useBundledJSF = false;
            this.extraClassPath = null;
            this.versionIdentifier = null;
            if (archive.exists(this.getXmlFileName())) {
                try (InputStream is = archive.getEntry(this.getXmlFileName());){
                    this.init(is);
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("Error in parsing {0} for archive [{1}]: {2}", this.getXmlFileName(), archive.getURI(), t.getMessage());
                    throw new RuntimeException(msg);
                }
            }
        }

        protected abstract String getXmlFileName();

        boolean isDelegate() {
            return this.delegate;
        }

        boolean isIgnoreHiddenJarFiles() {
            return this.ignoreHiddenJarFiles;
        }

        String getExtraClassPath() {
            return this.extraClassPath;
        }

        boolean isUseBundledJSF() {
            return this.useBundledJSF;
        }

        String getVersionIdentifier() {
            return this.versionIdentifier;
        }
    }

    protected class GlassFishWebXmlParser
    extends SunWebXmlParser {
        GlassFishWebXmlParser(ReadableArchive archive) throws XMLStreamException, IOException {
            super(archive);
        }

        @Override
        protected String getXmlFileName() {
            return WarHandler.GLASSFISH_WEB_XML;
        }

        @Override
        protected String getRootElementName() {
            return "glassfish-web-app";
        }
    }

    protected class WeblogicXmlParser
    extends WebXmlParser {
        WeblogicXmlParser(ReadableArchive archive) throws XMLStreamException, IOException {
            super(archive);
        }

        @Override
        protected String getXmlFileName() {
            return WarHandler.WEBLOGIC_XML;
        }

        @Override
        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            this.skipRoot("weblogic-web-app");
            int event = 0;
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("prefer-web-inf-classes".equals(name)) {
                    this.delegate = !Boolean.parseBoolean(this.parser.getElementText());
                    break;
                }
                if ("container-descriptor".equals(name)) continue;
                this.skipSubTree(name);
            }
        }
    }

    protected class SunWebXmlParser
    extends WebXmlParser {
        SunWebXmlParser(ReadableArchive archive) throws XMLStreamException, IOException {
            super(archive);
        }

        @Override
        protected String getXmlFileName() {
            return WarHandler.SUN_WEB_XML;
        }

        protected String getRootElementName() {
            return "sun-web-app";
        }

        @Override
        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean inClassLoader = false;
            this.skipRoot(this.getRootElementName());
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event == 1) {
                    String attrName;
                    int i;
                    String value;
                    int count;
                    String name = this.parser.getLocalName();
                    if ("class-loader".equals(name)) {
                        count = this.parser.getAttributeCount();
                        for (int i2 = 0; i2 < count; ++i2) {
                            String attrName2 = this.parser.getAttributeName(i2).getLocalPart();
                            if ("delegate".equals(attrName2)) {
                                this.delegate = Boolean.valueOf(this.parser.getAttributeValue(i2));
                                continue;
                            }
                            if ("extra-class-path".equals(attrName2)) {
                                this.extraClassPath = this.parser.getAttributeValue(i2);
                                continue;
                            }
                            if (!"dynamic-reload-interval".equals(attrName2) || this.parser.getAttributeValue(i2) == null || !LOG.isLoggable(Level.WARNING)) continue;
                            LOG.log(Level.WARNING, "AS-WEB-UTIL-00029");
                        }
                        inClassLoader = true;
                        continue;
                    }
                    if (inClassLoader && "property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(I18N.getString("AS-WEB-UTIL-00030"));
                        }
                        if ("ignoreHiddenJarFiles".equals(propName)) {
                            this.ignoreHiddenJarFiles = Boolean.valueOf(value);
                            continue;
                        }
                        Object[] params = new Object[]{propName, value};
                        if (!LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "AS-WEB-UTIL-00031", params);
                        continue;
                    }
                    if ("property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(I18N.getString("AS-WEB-UTIL-00030"));
                        }
                        if ("useMyFaces".equalsIgnoreCase(propName)) {
                            this.useBundledJSF = Boolean.valueOf(value);
                            continue;
                        }
                        if (!"useBundledJsf".equalsIgnoreCase(propName)) continue;
                        this.useBundledJSF = Boolean.valueOf(value);
                        continue;
                    }
                    if ("version-identifier".equals(name)) {
                        this.versionIdentifier = this.parser.getElementText();
                        continue;
                    }
                    this.skipSubTree(name);
                    continue;
                }
                if (!inClassLoader || event != 2 || !"class-loader".equals(this.parser.getLocalName())) continue;
                inClassLoader = false;
            }
        }
    }

    protected class ContextXmlParser
    extends BaseXmlParser {
        protected Boolean clearReferencesStatic;

        ContextXmlParser(File contextXmlFile) throws XMLStreamException, IOException {
            if (contextXmlFile.exists()) {
                try (FileInputStream is = new FileInputStream(contextXmlFile);){
                    this.init(is);
                }
            }
        }

        @Override
        protected void read(InputStream input) throws XMLStreamException {
            this.parser = WarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("Context".equals(name)) {
                    String path = null;
                    Boolean crs = null;
                    int count = this.parser.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        String attrName = this.parser.getAttributeName(i).getLocalPart();
                        if ("clearReferencesStatic".equals(attrName)) {
                            crs = Boolean.valueOf(this.parser.getAttributeValue(i));
                            continue;
                        }
                        if (!"path".equals(attrName)) continue;
                        path = this.parser.getAttributeValue(i);
                    }
                    if (path != null) continue;
                    this.clearReferencesStatic = crs;
                    break;
                }
                this.skipSubTree(name);
            }
        }

        Boolean getClearReferencesStatic() {
            return this.clearReferencesStatic;
        }
    }

    protected abstract class BaseXmlParser {
        protected XMLStreamReader parser;

        protected BaseXmlParser() {
        }

        protected abstract void read(InputStream var1) throws XMLStreamException;

        protected void init(InputStream input) throws XMLStreamException {
            try {
                this.read(input);
            }
            finally {
                if (this.parser != null) {
                    try {
                        this.parser.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            String localName = this.parser.getLocalName();
            if (!name.equals(localName)) {
                String msg = I18N.getString("AS-WEB-UTIL-00032");
                msg = MessageFormat.format(msg, name, localName);
                throw new XMLStreamException(msg);
            }
        }

        protected void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException(I18N.getString("AS-WEB-UTIL-00033"));
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }
    }
}

