/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.authorization.spi.impl;

import jakarta.ejb.EJBContext;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyFactory;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.glassfish.soteria.authorization.EJB;

class Authorization {
    public static String SUBJECT_CONTAINER_KEY = "javax.security.auth.Subject.container";

    Authorization() {
    }

    public static Subject getSubject() {
        return (Subject)Authorization.getFromContext(SUBJECT_CONTAINER_KEY);
    }

    public static boolean isCallerInRole(String role) {
        Subject subject = Authorization.getSubject();
        if (Authorization.hasPermission(subject, (Permission)new WebRoleRefPermission("", role))) {
            return true;
        }
        EJBContext ejbContext = EJB.getEJBContext();
        if (ejbContext != null) {
            String ejbName = EJB.getCurrentEJBName(ejbContext);
            if (ejbName != null) {
                return Authorization.hasPermission(subject, (Permission)new EJBRoleRefPermission(ejbName, role));
            }
            return ejbContext.isCallerInRole(role);
        }
        return false;
    }

    public static boolean hasAccessToWebResource(String resource, String ... methods) {
        return Authorization.hasPermission(Authorization.getSubject(), (Permission)new WebResourcePermission(resource, methods));
    }

    public static Set<String> getAllDeclaredCallerRoles() {
        PermissionCollection permissionCollection = Authorization.getPermissionCollection(Authorization.getSubject());
        permissionCollection.implies((Permission)new WebRoleRefPermission("", "nothing"));
        permissionCollection.implies((Permission)new EJBRoleRefPermission("", "nothing"));
        return Authorization.filterRoles(permissionCollection);
    }

    public static boolean hasPermission(Subject subject, Permission permission) {
        return Authorization.getPolicy().implies(permission, subject);
    }

    public static PermissionCollection getPermissionCollection(Subject subject) {
        return Authorization.getPolicy().getPermissionCollection(subject);
    }

    private static Policy getPolicy() {
        return PolicyFactory.getPolicyFactory().getPolicy();
    }

    public static Set<String> filterRoles(PermissionCollection permissionCollection) {
        HashSet<String> roles = new HashSet<String>();
        for (Permission permission : Collections.list(permissionCollection.elements())) {
            String role;
            if (!Authorization.isRolePermission(permission) || roles.contains(role = permission.getActions()) || !Authorization.isCallerInRole(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static <T> T getFromContext(String contextName) {
        try {
            return (T)PolicyContext.getContext((String)contextName);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public static boolean isRolePermission(Permission permission) {
        return permission instanceof WebRoleRefPermission || permission instanceof EJBRoleRefPermission;
    }
}

