/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.Tokenizer;
import com.sun.enterprise.admin.util.TokenizerException;
import com.sun.enterprise.admin.util.TokenizerInternal;
import java.util.ArrayList;

public final class TokenizerImpl
implements Tokenizer {
    final String[] mTokens;

    public TokenizerImpl(String input, String delimiters, char escapeChar, String escapableChars) throws TokenizerException {
        this(input, delimiters, true, escapeChar, escapableChars);
    }

    public TokenizerImpl(String input, String delimiters, boolean multipleDelimsCountAsOne, char escapeChar, String escapableChars) throws TokenizerException {
        TokenizerInternal worker = new TokenizerInternal(input, delimiters, escapeChar, escapableChars);
        ArrayList allTokens = worker.parseTokens();
        if (multipleDelimsCountAsOne) {
            allTokens = TokenizerImpl.removeMultipleDelims(allTokens);
        }
        this.mTokens = TokenizerImpl.interpretTokenList(allTokens);
    }

    static ArrayList removeMultipleDelims(ArrayList list) {
        ArrayList resultList = new ArrayList();
        boolean lastWasDelim = false;
        for (Object value : list) {
            if (value instanceof String) {
                resultList.add(value);
                lastWasDelim = false;
                continue;
            }
            if (lastWasDelim) continue;
            resultList.add(value);
            lastWasDelim = true;
        }
        return resultList;
    }

    static String[] interpretTokenList(ArrayList list) {
        ArrayList resultList = new ArrayList();
        boolean lastWasDelim = true;
        for (Object value : list) {
            if (value instanceof String) {
                resultList.add(value);
                lastWasDelim = false;
                continue;
            }
            if (lastWasDelim) {
                resultList.add("");
                continue;
            }
            lastWasDelim = true;
        }
        if (lastWasDelim && !list.isEmpty()) {
            resultList.add("");
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    @Override
    public String[] getTokens() {
        return this.mTokens;
    }
}

