/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.monitoring.stats.EjbMethodStatsProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;

public abstract class EjbMonitoringStatsProvider {
    Map<String, EjbMethodStatsProvider> methodMonitorMap;
    String appName = null;
    String moduleName = null;
    String beanName = null;
    boolean registered = false;
    protected long beanId;
    private CountStatisticImpl createStat = new CountStatisticImpl("CreateCount", "count", "Number of times EJB create method is called or 3.x bean is looked up");
    private CountStatisticImpl removeStat = new CountStatisticImpl("RemoveCount", "count", "Number of times EJB remove method is called");
    static final Logger _logger = EjbContainerUtilImpl.getLogger();

    public EjbMonitoringStatsProvider(long beanId, String appName, String moduleName, String beanName) {
        this.beanId = beanId;
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
    }

    public void addMethods(long beanId, String appName, String moduleName, String beanName, String[] method_sigs) {
        int bucketSz = method_sigs.length == 0 ? 16 : method_sigs.length << 1;
        this.methodMonitorMap = new HashMap<String, EjbMethodStatsProvider>(bucketSz);
        if (this.beanId == beanId) {
            for (String method_sig : method_sigs) {
                EjbMethodStatsProvider monitor = this.methodMonitorMap.get(method_sig);
                if (monitor != null) continue;
                monitor = new EjbMethodStatsProvider(method_sig);
                this.methodMonitorMap.put(method_sig, monitor);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[EJBMonitoringStatsProvider] : " + EjbMonitoringUtils.getLoggingName(appName, moduleName, beanName) + ":" + this.methodMonitorMap.size());
            }
        }
    }

    public void register() {
        String invokerId = EjbMonitoringUtils.getInvokerId(this.appName, this.moduleName, this.beanName);
        String beanSubTreeNode = EjbMonitoringUtils.registerComponent(this.appName, this.moduleName, this.beanName, this, invokerId);
        if (beanSubTreeNode != null) {
            this.registered = true;
            for (Map.Entry<String, EjbMethodStatsProvider> entry : this.methodMonitorMap.entrySet()) {
                String node;
                EjbMethodStatsProvider monitor = entry.getValue();
                if (monitor.isRegistered() || (node = EjbMonitoringUtils.registerMethod(beanSubTreeNode, monitor.getStringifiedMethodName(), monitor, invokerId)) == null) continue;
                monitor.registered();
            }
        }
    }

    public void unregister() {
        boolean debug = _logger.isLoggable(Level.FINE);
        if (this.registered) {
            if (debug) {
                _logger.log(Level.FINE, "[EJBMonitoringStatsProvider] unregister: " + EjbMonitoringUtils.getLoggingName(this.appName, this.moduleName, this.beanName));
            }
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
            for (EjbMethodStatsProvider monitor : this.methodMonitorMap.values()) {
                if (!monitor.isRegistered()) continue;
                if (debug) {
                    _logger.log(Level.FINE, "[EJBMonitoringStatsProvider] unregister method: " + monitor.getStringifiedMethodName());
                }
                monitor.unregistered();
                StatsProviderManager.unregister((Object)monitor);
            }
            this.methodMonitorMap.clear();
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodStartEvent")
    public void ejbMethodStartEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="method") String method_sig) {
        if (this.beanId == beanId) {
            this._log("ejbMethodStartEvent", method_sig);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(method_sig);
            if (monitor != null) {
                monitor.methodStart();
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodEndEvent")
    public void ejbMethodEndEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="exception") Throwable exception, @ProbeParam(value="method") String method_sig) {
        if (this.beanId == beanId) {
            this._log("ejbMethodEndEvent", method_sig);
            EjbMethodStatsProvider monitor = this.methodMonitorMap.get(method_sig);
            if (monitor != null) {
                monitor.methodEnd(exception == null);
            }
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanCreatedEvent")
    public void ejbBeanCreatedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this._log("ejbBeanCreatedEvent");
            this.createStat.increment();
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:beanDestroyedEvent")
    public void ejbBeanDestroyedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this._log("ejbBeanDestroyedEvent");
            this.removeStat.increment();
        }
    }

    @ManagedAttribute(id="createcount")
    @Description(value="Number of times EJB create method is called")
    public CountStatistic getCreateCount() {
        return this.createStat;
    }

    @ManagedAttribute(id="removecount")
    @Description(value="Number of times EJB remove method is called")
    public CountStatistic getRemoveCount() {
        return this.removeStat;
    }

    protected void log(String mname, String provider) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("===> In " + provider + " for: [" + mname + "] " + EjbMonitoringUtils.getLoggingName(this.appName, this.moduleName, this.beanName));
        }
    }

    private void _log(String mname) {
        this.log(mname, "EjbMonitoringStatsProvider");
    }

    private void _log(String mname, String method_sig) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("===> In EjbMonitoringStatsProvider for: [" + mname + "] " + EjbMonitoringUtils.getLoggingName(this.appName, this.moduleName, this.beanName) + "::" + method_sig);
        }
    }
}

