/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.CORBAObjectPermission;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.Object;

@Service
@Singleton
public class SecurityContextUtil
implements PostConstruct {
    private static final Logger LOG = LogDomains.getLogger(SecurityContextUtil.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    public static final int STATUS_PASSED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_RETRY = 2;
    private static final String IS_A = "_is_a";
    private Policy policy;
    @Inject
    private GlassFishORBHelper orbHelper;
    @Inject
    private SecurityMechanismSelector sms;

    public void postConstruct() {
        AccessController.doPrivileged(new PrivilegedAction<java.lang.Object>(){

            @Override
            public java.lang.Object run() {
                SecurityContextUtil.this.policy = Policy.getPolicy();
                return null;
            }
        });
    }

    public SecurityContext getSecurityContext(Object effective_target) throws InvalidMechanismException, InvalidIdentityTokenException {
        assert (this.orbHelper != null);
        IOR ior = ((ORB)this.orbHelper.getORB()).getIOR(effective_target, false);
        if (StubAdapter.isStub((java.lang.Object)effective_target) && StubAdapter.isLocal((java.lang.Object)effective_target)) {
            ConnectionExecutionContext.setClientThreadID(Thread.currentThread().getId());
            return null;
        }
        try {
            return this.sms.selectSecurityContext(ior);
        }
        catch (InvalidIdentityTokenException | InvalidMechanismException e) {
            throw e;
        }
        catch (SecurityMechanismException e) {
            throw new RuntimeException("Could not select a security context.", e);
        }
    }

    public static void receivedReply(int reply_status, Object effective_target) {
        if (reply_status == 1) {
            LOG.log(Level.FINE, "Failed status");
            throw new RuntimeException("Target did not accept security context");
        }
        if (reply_status == 2) {
            LOG.log(Level.FINE, "Retry status");
        } else {
            LOG.log(Level.FINE, "Passed status");
        }
    }

    public int setSecurityContext(SecurityContext context, byte[] object_id, String method, Socket socket) {
        LOG.log(Level.FINE, "ABOUT TO EVALUATE TRUST");
        try {
            SecurityContext ssc = this.sms.evaluateTrust(context, object_id, socket);
            Class cls = null;
            Subject s = null;
            if (ssc == null) {
                return 0;
            }
            cls = ssc.authcls == null ? ssc.identcls : ssc.authcls;
            s = ssc.subject;
            this.authenticate(s, cls);
            if (this.authorizeCORBA(object_id, method)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            if (!method.equals(IS_A)) {
                LOG.log(Level.FINE, "Authentication Exception", e);
            }
            return 1;
        }
    }

    private boolean authorizeCORBA(byte[] object_id, String method) throws Exception {
        ProtocolManager protocolMgr = this.orbHelper.getProtocolManager();
        if (protocolMgr == null) {
            return true;
        }
        if (protocolMgr.getEjbDescriptor(object_id) != null) {
            return true;
        }
        CORBAObjectPermission perm = new CORBAObjectPermission("*", method);
        com.sun.enterprise.security.SecurityContext sc = com.sun.enterprise.security.SecurityContext.getCurrent();
        Set principalSet = sc.getPrincipalSet();
        Principal[] principals = principalSet == null ? null : principalSet.toArray(new Principal[principalSet.size()]);
        CodeSource cs = new CodeSource(new URL("file://"), (Certificate[])null);
        ProtectionDomain prdm = new ProtectionDomain(cs, null, null, principals);
        boolean result = this.policy.implies(prdm, (Permission)perm);
        LOG.log(Level.FINE, "CORBA Object permission evaluation result={0} for method={1}", new java.lang.Object[]{result, method});
        return result;
    }

    public void sendingReply(SecurityContext context) {
    }

    public static void unsetSecurityContext(boolean isLocal) {
        if (!isLocal) {
            com.sun.enterprise.security.SecurityContext.setCurrent(null);
        }
    }

    private void authenticate(Subject s, Class cls) throws SecurityMechanismException {
        try {
            PrivilegedAction<Void> action = () -> {
                LoginContextDriver.login((Subject)s, (Class)cls);
                return null;
            };
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            throw new SecurityMechanismException("Cannot login user: " + e.getMessage(), e);
        }
    }
}

