/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSKeyBindingExtension;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;
import java.util.Iterator;

public class EncryptionPolicy
extends WSSKeyBindingExtension {
    public EncryptionPolicy() {
        this.setPolicyIdentifier("EncryptionPolicy");
        this._featureBinding = new FeatureBinding();
    }

    @Override
    public boolean equals(WSSPolicy policy) {
        boolean _assert = false;
        try {
            return this.equalsIgnoreTargets(policy);
        }
        catch (Exception exception) {
            return _assert;
        }
    }

    @Override
    public boolean equalsIgnoreTargets(WSSPolicy policy) {
        boolean _assert = false;
        try {
            if (PolicyTypeUtil.encryptionPolicy(policy)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _assert;
    }

    @Override
    public Object clone() {
        EncryptionPolicy ePolicy = new EncryptionPolicy();
        try {
            WSSPolicy fBinding = (WSSPolicy)this.getFeatureBinding();
            WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
            if (fBinding != null) {
                ePolicy.setFeatureBinding((MLSPolicy)fBinding.clone());
            }
            if (kBinding != null) {
                ePolicy.setKeyBinding((MLSPolicy)kBinding.clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ePolicy;
    }

    @Override
    public String getType() {
        return "EncryptionPolicy";
    }

    public static class FeatureBinding
    extends WSSPolicy {
        String _dataEncryptionAlgorithm = "";
        ArrayList _targets = new ArrayList();
        boolean standAloneRefList = false;
        boolean targetIsIssuedToken = false;
        boolean targetIsSignature = false;

        public FeatureBinding() {
            this.setPolicyIdentifier("EncryptionPolicy.FeatureBinding");
        }

        public String getDataEncryptionAlgorithm() {
            return this._dataEncryptionAlgorithm;
        }

        public void setDataEncryptionAlgorithm(String algorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set DateEncryptionAlgorithm : Policy is ReadOnly");
            }
            this._dataEncryptionAlgorithm = algorithm;
        }

        public ArrayList getTargetBindings() {
            return this._targets;
        }

        public void addTargetBinding(EncryptionTarget target) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not add Target : Policy is ReadOnly");
            }
            this._targets.add(target);
        }

        public void addTargetBinding(Target target) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not add Target : Policy is ReadOnly");
            }
            this._targets.add(new EncryptionTarget(target));
        }

        public void removeTargetBindings(ArrayList targets) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not remove Target : Policy is ReadOnly");
            }
            this._targets.removeAll(targets);
        }

        @Override
        public boolean equals(WSSPolicy policy) {
            try {
                FeatureBinding fBinding = (FeatureBinding)policy;
                boolean b1 = this._targets.equals(fBinding.getTargetBindings());
                if (!b1) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        @Override
        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return true;
        }

        @Override
        public Object clone() {
            FeatureBinding fBinding = new FeatureBinding();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator i = this.getTargetBindings().iterator();
                while (i.hasNext()) {
                    list.add(((EncryptionTarget)i.next()).clone());
                }
                fBinding.getTargetBindings().addAll(list);
                WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
                fBinding.setDataEncryptionAlgorithm(this.getDataEncryptionAlgorithm());
                if (kBinding != null) {
                    fBinding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            fBinding.encryptsIssuedToken(this.encryptsIssuedToken());
            fBinding.encryptsSignature(this.encryptsSignature());
            return fBinding;
        }

        @Override
        public String getType() {
            return "EncryptionPolicy.FeatureBinding";
        }

        public boolean encryptsIssuedToken() {
            return this.targetIsIssuedToken;
        }

        public void encryptsIssuedToken(boolean flag) {
            this.targetIsIssuedToken = flag;
        }

        public boolean encryptsSignature() {
            return this.targetIsSignature;
        }

        public void encryptsSignature(boolean flag) {
            this.targetIsSignature = flag;
        }

        public boolean getUseStandAloneRefList() {
            return this.standAloneRefList;
        }

        public void setUseStandAloneRefList(boolean value) {
            this.standAloneRefList = value;
        }
    }
}

