/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.SealedClass;
import org.jboss.cdi.lang.model.tck.SealedClassWithoutPermits;
import org.jboss.cdi.lang.model.tck.SealedEnum;

public class SealedClasses {
    SealedClass sealedClass;
    SealedClassWithoutPermits sealedClassWithoutPermits;
    SealedEnum sealedEnum;

    public static void verify(ClassInfo clazz) {
        SealedClasses.verifySealedClass(LangModelUtils.classOfField(clazz, "sealedClass"));
        SealedClasses.verifySealedClassWithoutPermits(LangModelUtils.classOfField(clazz, "sealedClassWithoutPermits"));
        SealedClasses.verifySealedEnum(LangModelUtils.classOfField(clazz, "sealedEnum"));
    }

    private static void verifySealedClass(ClassInfo clazz) {
        assert (clazz.isPlainClass());
        assert (clazz.isAbstract());
        assert (!clazz.isFinal());
        assert (clazz.isSealed());
        assert (clazz.permittedSubclasses().size() == 3);
        block10: for (ClassInfo subclass : clazz.permittedSubclasses()) {
            switch (subclass.simpleName()) {
                case "SubclassOfSealedClass1": {
                    assert (subclass.isPlainClass());
                    assert (subclass.isFinal());
                    assert (!subclass.isAbstract());
                    assert (!subclass.isSealed());
                    continue block10;
                }
                case "SubclassOfSealedClass2": {
                    assert (subclass.isPlainClass());
                    assert (!subclass.isFinal());
                    assert (!subclass.isAbstract());
                    assert (!subclass.isSealed());
                    continue block10;
                }
                case "SubclassOfSealedClass3": {
                    assert (subclass.isPlainClass());
                    assert (!subclass.isFinal());
                    assert (!subclass.isAbstract());
                    assert (subclass.isSealed());
                    assert (subclass.permittedSubclasses().size() == 1);
                    continue block10;
                }
            }
            throw new AssertionError((Object)("Unexpected subclass " + subclass + " of " + clazz));
        }
    }

    private static void verifySealedClassWithoutPermits(ClassInfo clazz) {
        assert (clazz.isPlainClass());
        assert (!clazz.isAbstract());
        assert (!clazz.isFinal());
        assert (clazz.isSealed());
        assert (clazz.permittedSubclasses().size() == 3);
        block10: for (ClassInfo subclass : clazz.permittedSubclasses()) {
            switch (subclass.simpleName()) {
                case "SubclassOfSealedClassWithoutPermits1": {
                    assert (subclass.isPlainClass());
                    assert (!subclass.isAbstract());
                    assert (subclass.isFinal());
                    assert (!subclass.isSealed());
                    continue block10;
                }
                case "SubclassOfSealedClassWithoutPermits2": {
                    assert (subclass.isPlainClass());
                    assert (!subclass.isAbstract());
                    assert (!subclass.isFinal());
                    assert (!subclass.isSealed());
                    continue block10;
                }
                case "SubclassOfSealedClassWithoutPermits3": {
                    assert (subclass.isPlainClass());
                    assert (!subclass.isAbstract());
                    assert (!subclass.isFinal());
                    assert (subclass.isSealed());
                    assert (subclass.permittedSubclasses().size() == 1);
                    continue block10;
                }
            }
            throw new AssertionError((Object)("Unexpected subclass " + subclass + " of " + clazz));
        }
    }

    private static void verifySealedEnum(ClassInfo clazz) {
        assert (clazz.isEnum());
        assert (!clazz.isAbstract());
        assert (!clazz.isFinal());
        assert (clazz.isSealed());
        assert (clazz.permittedSubclasses().size() == 2);
    }
}

