/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.RealNumbers;
import org.assertj.core.util.VisibleForTesting;

public class Doubles
extends RealNumbers<Double> {
    private static final Doubles INSTANCE = new Doubles();

    public static Doubles instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Doubles() {
    }

    public Doubles(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Double zero() {
        return 0.0;
    }

    @Override
    protected Double one() {
        return 1.0;
    }

    @Override
    protected Double NaN() {
        return Double.NaN;
    }

    @Override
    protected Double absDiff(Double actual, Double other) {
        return this.isNanOrInfinite(actual) || this.isNanOrInfinite(other) ? Math.abs(actual - other) : Math.abs(this.absBigDecimalDiff(actual, other).doubleValue());
    }

    @Override
    protected boolean isFinite(Double value) {
        return Double.isFinite(value);
    }

    @Override
    protected boolean isNotFinite(Double value) {
        return !Double.isFinite(value);
    }

    @Override
    protected boolean isInfinite(Double value) {
        return Double.isInfinite(value);
    }

    @Override
    protected boolean isNotInfinite(Double value) {
        return !Double.isInfinite(value);
    }

    @Override
    protected boolean isNaN(Double value) {
        return Double.isNaN(value);
    }
}

