/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.traversableresolver;

import jakarta.validation.Configuration;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Call;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.ExceptionThrowingTraversableResolver;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Gentleman;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Jacket;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Person;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.SnifferTraversableResolver;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Suit;
import org.hibernate.beanvalidation.tck.tests.traversableresolver.Trousers;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class TraversableResolverTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)TraversableResolverTest.webArchiveBuilder().withTestClassPackage(TraversableResolverTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="k"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="l")})
    public void testCorrectCallsToIsReachableAndIsCascadable() {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        HashSet<Call> expectedReachCalls = new HashSet<Call>();
        HashSet<Call> expectedCascadeCalls = new HashSet<Call>();
        expectedReachCalls.add(new Call(suit, "size", Suit.class, ElementType.FIELD, new String[]{null}));
        expectedReachCalls.add(new Call(suit, "trousers", Suit.class, ElementType.FIELD, new String[]{null}));
        expectedCascadeCalls.add(new Call(suit, "trousers", Suit.class, ElementType.FIELD, new String[]{null}));
        expectedReachCalls.add(new Call(suit.getTrousers(), "length", Suit.class, ElementType.FIELD, new String[]{"trousers"}));
        expectedReachCalls.add(new Call(suit, "jacket", Suit.class, ElementType.METHOD, new String[]{null}));
        expectedCascadeCalls.add(new Call(suit, "jacket", Suit.class, ElementType.METHOD, new String[]{null}));
        expectedReachCalls.add(new Call(suit.getJacket(), "width", Suit.class, ElementType.METHOD, new String[]{"jacket"}));
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(expectedReachCalls, expectedCascadeCalls);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        v.validate((Object)suit, new Class[0]);
        Assert.assertEquals((int)resolver.getReachableCallCount(), (int)5);
        Assert.assertEquals((int)resolver.getCascadableCallCount(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="h")})
    public void testCorrectCallsToIsReachableAndIsCascadableForValidateValue() {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        HashSet<Call> expectedReachCalls = new HashSet<Call>();
        HashSet<Call> expectedCascadeCalls = new HashSet<Call>();
        expectedReachCalls.add(new Call(null, "size", Suit.class, ElementType.FIELD, new String[]{null}));
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(expectedReachCalls, expectedCascadeCalls);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        v.validateValue(Suit.class, "size", (Object)3333, new Class[0]);
        Assert.assertEquals((int)resolver.getReachableCallCount(), (int)1);
        Assert.assertEquals((int)resolver.getCascadableCallCount(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="k"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="l")})
    public void testCorrectCallsToIsReachableAndIsCascadableForParameterValidation() throws Exception {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        HashSet<Call> expectedReachCalls = new HashSet<Call>();
        HashSet<Call> expectedCascadeCalls = new HashSet<Call>();
        expectedReachCalls.add(new Call(suit, "size", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "suit"}));
        expectedReachCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "suit"}));
        expectedCascadeCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "suit"}));
        expectedReachCalls.add(new Call(suit.getTrousers(), "length", Gentleman.class, ElementType.FIELD, new String[]{"wearSuit", "suit", "trousers"}));
        expectedReachCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"wearSuit", "suit"}));
        expectedCascadeCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"wearSuit", "suit"}));
        expectedReachCalls.add(new Call(suit.getJacket(), "width", Gentleman.class, ElementType.METHOD, new String[]{"wearSuit", "suit", "jacket"}));
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(expectedReachCalls, expectedCascadeCalls);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        ExecutableValidator executableValidator = factory.getValidator().forExecutables();
        Gentleman gentleman = new Gentleman();
        Method method = Gentleman.class.getMethod("wearSuit", Suit.class);
        Object[] parameterValues = new Object[]{suit};
        executableValidator.validateParameters((Object)gentleman, method, parameterValues, new Class[0]);
        Assert.assertEquals((int)resolver.getReachableCallCount(), (int)5);
        Assert.assertEquals((int)resolver.getCascadableCallCount(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="d"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="e"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="f"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="g"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="h"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="k"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="l")})
    public void testCorrectCallsToIsReachableAndIsCascadableForReturnValueValidation() throws Exception {
        Suit suit = new Suit();
        suit.setTrousers(new Trousers());
        suit.setJacket(new Jacket());
        suit.setSize(3333);
        suit.getTrousers().setLength(32321);
        suit.getJacket().setWidth(432432);
        HashSet<Call> expectedReachCalls = new HashSet<Call>();
        HashSet<Call> expectedCascadeCalls = new HashSet<Call>();
        expectedReachCalls.add(new Call(suit, "size", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>"}));
        expectedReachCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>"}));
        expectedCascadeCalls.add(new Call(suit, "trousers", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>"}));
        expectedReachCalls.add(new Call(suit.getTrousers(), "length", Gentleman.class, ElementType.FIELD, new String[]{"undress", "<return value>", "trousers"}));
        expectedReachCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"undress", "<return value>"}));
        expectedCascadeCalls.add(new Call(suit, "jacket", Gentleman.class, ElementType.METHOD, new String[]{"undress", "<return value>"}));
        expectedReachCalls.add(new Call(suit.getJacket(), "width", Gentleman.class, ElementType.METHOD, new String[]{"undress", "<return value>", "jacket"}));
        SnifferTraversableResolver resolver = new SnifferTraversableResolver(expectedReachCalls, expectedCascadeCalls);
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        ExecutableValidator executableValidator = factory.getValidator().forExecutables();
        Gentleman gentleman = new Gentleman();
        gentleman.wearSuit(suit);
        Method method = Gentleman.class.getMethod("undress", new Class[0]);
        executableValidator.validateReturnValue((Object)gentleman, method, (Object)suit, new Class[0]);
        Assert.assertEquals((int)resolver.getReachableCallCount(), (int)5);
        Assert.assertEquals((int)resolver.getCascadableCallCount(), (int)2);
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="i")
    public void testCustomTraversableResolverViaConfiguration() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        configuration.traversableResolver((TraversableResolver)new DummyTraversableResolver());
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Validator validator = factory.getValidator();
        Person person = new Person();
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="c")
    public void testTraversableResolverFromValidatorFactory() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        DummyTraversableResolver traversableResolver = new DummyTraversableResolver();
        configuration.traversableResolver((TraversableResolver)traversableResolver);
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertSame((Object)factory.getTraversableResolver(), (Object)traversableResolver);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-traversable", id="j")
    public void testResolverExceptionsGetWrappedInValidationException() {
        ExceptionThrowingTraversableResolver resolver = new ExceptionThrowingTraversableResolver();
        Configuration config = TestUtil.getConfigurationUnderTest().traversableResolver((TraversableResolver)resolver);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        v.validate((Object)new Suit(), new Class[0]);
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="b")
    public void testDefaultTraversableResolverIsNotNull() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        Assert.assertNotNull((Object)config.getDefaultTraversableResolver());
    }

    private static class DummyTraversableResolver
    implements TraversableResolver {
        private DummyTraversableResolver() {
        }

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }
    }
}

