/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

class ComposedImageDescriptor
extends CompositeImageDescriptor {
    private static final long serialVersionUID = 1L;
    protected ComposedImage composedImage;
    protected List<ImageData> imageDatas;

    public ComposedImageDescriptor(ComposedImage composedImage) {
        this.composedImage = composedImage;
    }

    public void drawCompositeImage(int width, int height) {
        ComposedImage.Size size = new ComposedImage.Size();
        size.width = width;
        size.height = height;
        Iterator<ImageData> images = this.imageDatas.iterator();
        for (ComposedImage.Point point : this.composedImage.getDrawPoints(size)) {
            this.drawImage(images.next(), point.x, point.y);
        }
    }

    public Point getSize() {
        List images = this.composedImage.getImages();
        this.imageDatas = new ArrayList<ImageData>(images.size());
        ArrayList<ComposedImage.Size> sizes = new ArrayList<ComposedImage.Size>(images.size());
        for (Object object : images) {
            Image image = ExtendedImageRegistry.getInstance().getImage(object);
            ImageData imageData = image.getImageData();
            this.imageDatas.add(imageData);
            ComposedImage.Size size = new ComposedImage.Size();
            size.width = imageData.width;
            size.height = imageData.height;
            sizes.add(size);
        }
        ComposedImage.Size result = this.composedImage.getSize(sizes);
        return new Point(result.width, result.height);
    }
}

