/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.cachetree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class CachedTreeNode<T> {
    private T ownValue;
    private T cachedChildrenValue;
    private final Map<Object, T> cache;
    private Object parent;

    public CachedTreeNode(T initialValue) {
        this.ownValue = initialValue;
        this.cache = new LinkedHashMap<Object, T>();
    }

    protected abstract void update();

    public void putIntoCache(Object key, T value) {
        this.cache.put(key, value);
        this.update();
    }

    public void removeFromCache(Object key) {
        this.cache.remove(key);
        this.update();
    }

    public T getOwnValue() {
        return this.ownValue;
    }

    public void setOwnValue(T newValue) {
        this.ownValue = newValue;
    }

    public Collection<T> values() {
        return this.cache.values();
    }

    public T getChildValue() {
        return this.cachedChildrenValue;
    }

    protected void setChildValue(T childValue) {
        this.cachedChildrenValue = childValue;
    }

    public abstract T getDisplayValue();

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }
}

