/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.swt;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.model.common.di.annotations.Renderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.emfforms.bazaar.Bid;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.reveal.EMFFormsRevealProvider;
import org.eclipse.emfforms.spi.core.services.reveal.Reveal;
import org.eclipse.emfforms.spi.core.services.reveal.RevealHelper;
import org.eclipse.emfforms.spi.core.services.reveal.RevealStep;
import org.osgi.service.component.annotations.Component;

@Component(name="tableRevealProvider")
public class TableRevealProvider
implements EMFFormsRevealProvider {
    private final Double tableBid = 5.0;

    @Bid
    public Double canReveal(VTableControl tableControl, EObject object, ViewModelContext context) {
        return this.contains(context, tableControl, object) ? this.tableBid : null;
    }

    private boolean contains(ViewModelContext context, VTableControl tableControl, EObject object) {
        boolean result = false;
        try {
            IObservableList list = ((EMFFormsDatabinding)context.getService(EMFFormsDatabinding.class)).getObservableList(tableControl.getDomainModelReference(), context.getDomainModel());
            result = list.contains((Object)object);
        }
        catch (DatabindingFailedException databindingFailedException) {
            // empty catch block
        }
        return result;
    }

    @Create
    public RevealStep reveal(ViewModelContext context, RevealHelper helper, VTableControl tableControl, EObject object) {
        RevealStep result = RevealStep.fail();
        if (this.contains(context, tableControl, object)) {
            result = helper.defer((Object)this);
        }
        return result;
    }

    @Reveal
    private RevealStep doReveal(@Renderer TableControlSWTRenderer renderer, EObject object) {
        VTableControl tableControl = (VTableControl)renderer.getVElement();
        return RevealStep.reveal((VElement)tableControl, (EObject)object, () -> {
            boolean bl = renderer.reveal(object);
        });
    }
}

