/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.rulerepository.tooling.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emfforms.internal.rulerepository.tooling.wizard.Messages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class EMFFormsNewRuleRepositoryWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private final ISelection selection;

    public EMFFormsNewRuleRepositoryWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.EMFFormsRuleRepositoryWizardPage_title);
        this.setDescription(Messages.EMFFormsRuleRepositoryWizardPage_description);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.EMFFormsRuleRepositoryWizardPage_containerSelection);
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EMFFormsNewRuleRepositoryWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.EMFFormsRuleRepositoryWizardPage_browseContainer);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EMFFormsNewRuleRepositoryWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.EMFFormsRuleRepositoryWizardPage_fileSelection);
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EMFFormsNewRuleRepositoryWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText("new_file.rulerepository");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.EMFFormsRuleRepositoryWizardPage_browseFile);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        if (this.getContainerName().length() == 0) {
            this.updateStatus(Messages.EMFFormsRuleRepositoryWizardPage_errorNoContainer);
            return;
        }
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String message = EMFFormsNewRuleRepositoryWizardPage.getContainerErrorMessage(container);
        if (message != null) {
            this.updateStatus(message);
            return;
        }
        String fileName = this.getFileName();
        if (fileName.length() == 0) {
            this.updateStatus(Messages.EMFFormsRuleRepositoryWizardPage_errorNoFilename);
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(Messages.EMFFormsRuleRepositoryWizardPage_errorInvalidFilename);
            return;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().getFile(container.getFullPath().append(fileName)).exists()) {
            this.updateStatus(String.format(Messages.EMFFormsRuleRepositoryWizardPage_FileAlreadyExist, fileName));
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("rulerepository")) {
            this.updateStatus(String.format(Messages.EMFFormsRuleRepositoryWizardPage_errorWrongFileExtension, "rulerepository"));
            return;
        }
        this.updateStatus(null);
    }

    public static String getContainerErrorMessage(IResource container) {
        if (container == null || (container.getType() & 6) == 0) {
            return Messages.EMFFormsRuleRepositoryWizardPage_errorContainerNotExists;
        }
        if (!container.isAccessible()) {
            return Messages.EMFFormsRuleRepositoryWizardPage_errorProjectReadOnly;
        }
        return null;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

