/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.swt;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.table.swt.Activator;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.ECPCellReadOnlyTester;

public final class CellReadOnlyTesterHelper {
    private static CellReadOnlyTesterHelper instance;
    private final Set<ECPCellReadOnlyTester> testers = new LinkedHashSet<ECPCellReadOnlyTester>();

    public static CellReadOnlyTesterHelper getInstance() {
        if (instance == null) {
            instance = new CellReadOnlyTesterHelper();
        }
        return instance;
    }

    private CellReadOnlyTesterHelper() {
        this.readExtensionPoint();
    }

    private void readExtensionPoint() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.table.ui.swt.cellReadOnly");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ECPCellReadOnlyTester tester = (ECPCellReadOnlyTester)e.createExecutableExtension("class");
                this.testers.add(tester);
            }
            catch (CoreException e1) {
                Activator.log(e1);
            }
            ++n2;
        }
    }

    public void registerCellReadOnlyTester(ECPCellReadOnlyTester tester) {
        this.testers.add(tester);
    }

    public boolean isReadOnly(VTableControl vTableControl, EStructuralFeature.Setting setting) {
        boolean result = false;
        for (ECPCellReadOnlyTester tester : this.testers) {
            result |= tester.isCellReadOnly(vTableControl, setting);
        }
        return result;
    }
}

