/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.categorization.expandbar;

import java.util.LinkedHashSet;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.view.spi.categorization.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizableElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizationElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class ExpandBarCategorizationElementRenderer
extends AbstractSWTRenderer<VCategorizationElement> {
    private static final String VALIDATION_ERRORS = "validationErrors";
    private SWTGridDescription gridDescription;
    private final EMFFormsRendererFactory emfFormsRendererFactory;
    private ScrolledComposite editorComposite;
    private AdapterFactoryLabelProvider labelProvider;
    private ExpandBar expandBar;
    private final EMFDataBindingContext dbc;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryContentProvider contentProvider;

    @Inject
    public ExpandBarCategorizationElementRenderer(VCategorizationElement vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory emfFormsRendererFactory) {
        super((VElement)vElement, viewContext, reportService);
        this.emfFormsRendererFactory = emfFormsRendererFactory;
        this.dbc = new EMFDataBindingContext();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.gridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        EList categorizations = ((VCategorizationElement)this.getVElement()).getCategorizations();
        if (categorizations.size() == 1 && categorizations.get(0) instanceof VCategory) {
            AbstractSWTRenderer renderer;
            VElement child = (VElement)categorizations.get(0);
            try {
                renderer = this.getEMFFormsRendererFactory().getRendererInstance(child, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
                return null;
            }
            Control render = renderer.render(cell, parent);
            renderer.finalizeRendering(parent);
            SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)render, (VElement)this.getVElement(), (String)"vcategory", (ViewModelContext)this.getViewModelContext());
            return render;
        }
        Object detailPane = this.getViewModelContext().getContextValue("detailPane");
        if (detailPane != null && Composite.class.isInstance(detailPane)) {
            Composite expandBar = this.createExpandBarMaster(parent);
            this.editorComposite = this.createdEditorPane((Composite)Composite.class.cast(detailPane));
            ((Composite)Composite.class.cast(detailPane)).layout();
            this.selectFirstEntry();
            return expandBar;
        }
        SashForm sashForm = new SashForm(parent, 256);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)sashForm, (VElement)this.getVElement(), (String)"sash", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)sashForm);
        Composite expandBar = this.createExpandBarMaster((Composite)sashForm);
        this.editorComposite = this.createdEditorPane((Composite)sashForm);
        sashForm.setWeights(new int[]{1, 3});
        this.selectFirstEntry();
        return sashForm;
    }

    private void selectFirstEntry() {
        if (this.expandBar.getItemCount() != 0) {
            TableViewer tableViewer = (TableViewer)TableViewer.class.cast(this.expandBar.getItem(0).getData("tableViewer"));
            tableViewer.setSelection((ISelection)new StructuredSelection(tableViewer.getElementAt(0)));
        }
    }

    private Composite createExpandBarMaster(Composite parent) {
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory){

            public Image getImage(Object object) {
                return null;
            }

            public Image getColumnImage(Object object, int columnIndex) {
                return null;
            }

            public String getColumnText(Object object, int columnIndex) {
                String result = super.getColumnText(object, columnIndex);
                VDiagnostic diagnostic = ((VCategory)VCategory.class.cast(object)).getDiagnostic();
                if (diagnostic != null && diagnostic.getHighestSeverity() > 0) {
                    result = String.valueOf(result) + String.format(" <span style='background-color:#%2$s;border-radius: 1em;color:#%3$s;height:1.25em;width:1.25em;display:inline-block;text-align:center'>%1$s</span>", diagnostic.getDiagnostics().size(), SWTValidationHelper.INSTANCE.getValidationColorHEX(diagnostic.getHighestSeverity(), ExpandBarCategorizationElementRenderer.this.getVElement(), ExpandBarCategorizationElementRenderer.this.getViewModelContext()), ExpandBarCategorizationElementRenderer.this.getFontColor());
                }
                return String.format("<span style='display:inline-block;margin-left:1.25em;'>%1$s</span>", result);
            }
        };
        Composite expandBarComposite = new Composite(parent, 2048);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)expandBarComposite, (VElement)this.getVElement(), (String)"expandBarComposite", (ViewModelContext)this.getViewModelContext());
        expandBarComposite.setLayout((Layout)new GridLayout());
        this.expandBar = new ExpandBar(expandBarComposite, 512);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.expandBar, (VElement)this.getVElement(), (String)"expandBar", (ViewModelContext)this.getViewModelContext());
        this.expandBar.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        int destroyedItems = 0;
        for (VAbstractCategorization categorization : ((VCategorizationElement)this.getVElement()).getCategorizations()) {
            ExpandItem item = this.createExpandItem(this.adapterFactory, categorization, destroyedItems);
            item.setExpanded(true);
            categorization.eAdapters().add((Object)new CategorizationVisibilityAdapter(categorization, item));
            if (categorization.isVisible()) continue;
            item.dispose();
            ++destroyedItems;
        }
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 5000).applyTo((Control)this.expandBar);
        return expandBarComposite;
    }

    private ExpandItem createExpandItem(ComposedAdapterFactory adapterFactory, VAbstractCategorization categorization, int destroyedItems) {
        ExpandItem item = new ExpandItem(this.expandBar, 0, ((VCategorizationElement)this.getVElement()).getCategorizations().indexOf((Object)categorization) - destroyedItems);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)item, (VElement)categorization, (String)"expandItem", (ViewModelContext)this.getViewModelContext());
        item.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        ISWTObservableValue target = WidgetProperties.text().observe((Widget)item);
        IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)categorization), (EObject)categorization, (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
        this.dbc.bindValue((IObservableValue)target, modelValue);
        item.setImage(this.labelProvider.getImage((Object)categorization));
        TableViewer tv = new TableViewer((Composite)this.expandBar, 770);
        tv.getTable().setHeaderVisible(false);
        tv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tv.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return VCategory.class.isInstance(element) && ((VCategory)VCategory.class.cast(element)).isVisible();
            }
        });
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        tv.setContentProvider((IContentProvider)this.contentProvider);
        tv.setInput(VCategorization.class.cast(categorization));
        tv.addSelectionChangedListener((ISelectionChangedListener)new CustomTableSelectionAdapter());
        tv.getTable().setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        tv.getTable().setData("org.eclipse.rap.rwt.markupValidationDisabled", (Object)Boolean.TRUE);
        item.setControl(tv.getControl());
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)tv.getControl(), (VElement)categorization, (String)"expandItemContent", (ViewModelContext)this.getViewModelContext());
        item.setHeight(this.computeHeight(item.getControl()));
        if (categorization.getDiagnostic() != null && categorization.getDiagnostic().getHighestSeverity() > 0) {
            item.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getValidationKey(categorization));
        }
        item.setData("tableViewer", (Object)tv);
        return item;
    }

    private String getValidationKey(VAbstractCategorization categorization) {
        switch (categorization.getDiagnostic().getHighestSeverity()) {
            case 1: {
                return "validationErrors_info";
            }
            case 2: {
                return "validationErrors_warning";
            }
            case 4: {
                return "validationErrors_error";
            }
            case 8: {
                return "validationErrors_cancel";
            }
        }
        return VALIDATION_ERRORS;
    }

    private String getFontColor() {
        return "ffffff";
    }

    private int computeHeight(Control control) {
        return control.computeSize((int)-1, (int)-1).y + 1;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(7, 7).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        return composite;
    }

    protected ScrolledComposite createdEditorPane(Composite composite) {
        ScrolledComposite editorComposite = this.createScrolledComposite(composite);
        editorComposite.setExpandHorizontal(true);
        editorComposite.setExpandVertical(true);
        editorComposite.setShowFocusedControl(true);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)editorComposite, (VElement)this.getVElement(), (String)"editorComposite", (ViewModelContext)this.getViewModelContext());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)editorComposite);
        return editorComposite;
    }

    private ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setShowFocusedControl(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setBackground(parent.getBackground());
        return scrolledComposite;
    }

    private EMFFormsRendererFactory getEMFFormsRendererFactory() {
        return this.emfFormsRendererFactory;
    }

    protected void applyValidation() {
        super.applyValidation();
        this.labelProvider.fireLabelProviderChanged();
        int i = 0;
        while (i < this.expandBar.getItemCount()) {
            ExpandItem expandItem = this.expandBar.getItem(i);
            VAbstractCategorization categorization = (VAbstractCategorization)((VCategorizationElement)this.getVElement()).getCategorizations().get(i);
            expandItem.setImage(this.labelProvider.getImage((Object)categorization));
            if (categorization.getDiagnostic() != null && categorization.getDiagnostic().getHighestSeverity() > 0) {
                expandItem.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getValidationKey(categorization));
            } else {
                expandItem.setData("org.eclipse.rap.rwt.customVariant", null);
            }
            ++i;
        }
    }

    protected void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        for (VAbstractCategorization categorization : ((VCategorizationElement)this.getVElement()).getCategorizations()) {
            LinkedHashSet<Adapter> toRemove = new LinkedHashSet<Adapter>();
            for (Adapter adapter : categorization.eAdapters()) {
                if (!CategorizationVisibilityAdapter.class.isInstance(adapter)) continue;
                toRemove.add(adapter);
            }
            categorization.eAdapters().removeAll(toRemove);
        }
        super.dispose();
    }

    private final class CategorizationVisibilityAdapter
    extends AdapterImpl {
        private final VAbstractCategorization categorization;
        private ExpandItem catItem;

        private CategorizationVisibilityAdapter(VAbstractCategorization categorization, ExpandItem item) {
            this.categorization = categorization;
            this.catItem = item;
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getFeature() != VViewPackage.eINSTANCE.getElement_Visible()) {
                return;
            }
            if (!this.categorization.isVisible()) {
                if (this.catItem.getControl().isFocusControl()) {
                    ExpandBarCategorizationElementRenderer.this.expandBar.forceFocus();
                }
                this.catItem.dispose();
            } else {
                int index = Math.min(ExpandBarCategorizationElementRenderer.this.expandBar.getChildren().length, ((VCategorizationElement)ExpandBarCategorizationElementRenderer.this.getVElement()).getCategorizations().indexOf((Object)this.categorization));
                this.catItem = ExpandBarCategorizationElementRenderer.this.createExpandItem(ExpandBarCategorizationElementRenderer.this.adapterFactory, this.categorization, index);
            }
        }
    }

    private class CustomTableSelectionAdapter
    implements ISelectionChangedListener {
        private Composite childComposite;

        private CustomTableSelectionAdapter() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            int i = 0;
            while (i < ExpandBarCategorizationElementRenderer.this.expandBar.getItemCount()) {
                ExpandItem expandItem = ExpandBarCategorizationElementRenderer.this.expandBar.getItem(i);
                Table table = (Table)expandItem.getControl();
                if (((TableViewer)TableViewer.class.cast(event.getSource())).getTable() != table) {
                    table.deselectAll();
                }
                ++i;
            }
            Object selection = ((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).getFirstElement();
            if (this.childComposite != null) {
                this.childComposite.dispose();
                this.childComposite = null;
            }
            if (selection == null) {
                return;
            }
            this.childComposite = ExpandBarCategorizationElementRenderer.this.createComposite((Composite)ExpandBarCategorizationElementRenderer.this.editorComposite);
            this.childComposite.setBackground(ExpandBarCategorizationElementRenderer.this.editorComposite.getBackground());
            ExpandBarCategorizationElementRenderer.this.editorComposite.setContent((Control)this.childComposite);
            VElement child = (VElement)selection;
            try {
                AbstractSWTRenderer renderer;
                try {
                    renderer = ExpandBarCategorizationElementRenderer.this.getEMFFormsRendererFactory().getRendererInstance(child, ExpandBarCategorizationElementRenderer.this.getViewModelContext());
                }
                catch (EMFFormsNoRendererException ex) {
                    ExpandBarCategorizationElementRenderer.this.getReportService().report(new AbstractReport((Throwable)ex));
                    return;
                }
                Control render = renderer.render((SWTGridCell)renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription()).getGrid().get(0), this.childComposite);
                renderer.finalizeRendering(this.childComposite);
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(-1, 200).applyTo(render);
                ((VCategorizationElement)ExpandBarCategorizationElementRenderer.this.getVElement()).setCurrentSelection((VCategorizableElement)child);
            }
            catch (NoRendererFoundException e) {
                ExpandBarCategorizationElementRenderer.this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            }
            catch (NoPropertyDescriptorFoundExeption e) {
                ExpandBarCategorizationElementRenderer.this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
            }
            this.childComposite.layout();
            Point point = this.childComposite.computeSize(-1, -1);
            ExpandBarCategorizationElementRenderer.this.editorComposite.setMinSize(point);
        }
    }
}

