/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangeServiceInterfaceCommentCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangeServiceInterfaceNameCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.SequenceRootEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeOutputPrimitiveOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeServiceSequenceOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTransactionOrderCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ServiceSection
extends AbstractSection {
    private TreeViewer sequencesViewer;
    private Text leftNameInput;
    private Text rightNameInput;
    private Text leftCommentInput;
    private Text rightCommentInput;

    protected FBType getType() {
        return (FBType)this.type;
    }

    protected FBType getInputType(Object input) {
        if (input instanceof SequenceRootEditPart) {
            return (FBType)((SequenceRootEditPart)((Object)input)).getCastedModel().eContainer();
        }
        if (input instanceof Service) {
            return (FBType)((Service)input).eContainer();
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite interfaceSection = this.getWidgetFactory().createComposite(parent);
        interfaceSection.setLayout((Layout)new GridLayout(2, false));
        interfaceSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInterfaceSection(interfaceSection);
        Composite sequencesSection = this.getWidgetFactory().createComposite(parent);
        sequencesSection.setLayout((Layout)new GridLayout(1, false));
        sequencesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSequencesSection(sequencesSection);
    }

    private void createInterfaceSection(Composite parent) {
        Group leftInterfaceGroup = this.getWidgetFactory().createGroup(parent, Messages.ServiceSection_LeftInterface);
        leftInterfaceGroup.setLayout((Layout)new GridLayout(1, true));
        leftInterfaceGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite leftInterfaceComposite = this.getWidgetFactory().createComposite((Composite)leftInterfaceGroup);
        leftInterfaceComposite.setLayout((Layout)new GridLayout(4, false));
        leftInterfaceComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(leftInterfaceComposite, Messages.ServiceSection_Name);
        this.leftNameInput = new Text(leftInterfaceComposite, 2048);
        this.leftNameInput.setLayoutData((Object)new GridData(4, 0, false, false));
        this.leftNameInput.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeServiceInterfaceNameCommand(this.leftNameInput.getText(), this.getType(), true));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(leftInterfaceComposite, Messages.ServiceSection_Comment);
        this.leftCommentInput = new Text(leftInterfaceComposite, 2048);
        this.leftCommentInput.setLayoutData((Object)new GridData(4, 0, true, false));
        this.leftCommentInput.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeServiceInterfaceCommentCommand(this.leftCommentInput.getText(), this.getType().getService(), true));
            this.addContentAdapter();
        });
        Group rightInterfaceGroup = this.getWidgetFactory().createGroup(parent, Messages.ServiceSection_RightInterface);
        rightInterfaceGroup.setLayout((Layout)new GridLayout(1, true));
        rightInterfaceGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite rightInterfaceComposite = this.getWidgetFactory().createComposite((Composite)rightInterfaceGroup);
        rightInterfaceComposite.setLayout((Layout)new GridLayout(4, false));
        rightInterfaceComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(rightInterfaceComposite, Messages.ServiceSection_Name);
        this.rightNameInput = new Text(rightInterfaceComposite, 2048);
        this.rightNameInput.setLayoutData((Object)new GridData(0, 0, false, false));
        this.rightNameInput.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeServiceInterfaceNameCommand(this.rightNameInput.getText(), this.getType(), false));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(rightInterfaceComposite, Messages.ServiceSection_Comment);
        this.rightCommentInput = new Text(rightInterfaceComposite, 2048);
        this.rightCommentInput.setLayoutData((Object)new GridData(4, 0, true, false));
        this.rightCommentInput.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangeServiceInterfaceCommentCommand(this.rightCommentInput.getText(), this.getType().getService(), false));
            this.addContentAdapter();
        });
    }

    private void createSequencesSection(Composite parent) {
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, Messages.ServiceSection_ServiceSequences);
        transactionGroup.setLayout((Layout)new GridLayout(2, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createButtons(transactionGroup);
        this.sequencesViewer = new TreeViewer((Composite)transactionGroup, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        gridData.widthHint = 80;
        this.sequencesViewer.getTree().setLayoutData((Object)gridData);
        this.sequencesViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.getAdapterFactory()));
        this.sequencesViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
    }

    private void createButtons(Group transactionGroup) {
        Composite buttonComp = ServiceSection.createButtonContainer((FormToolkit)this.getWidgetFactory(), (Composite)transactionGroup);
        buttonComp.setLayout((Layout)new FillLayout(512));
        Button sequenceNew = this.getWidgetFactory().createButton(buttonComp, "", 8);
        sequenceNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        sequenceNew.addListener(13, e -> this.executeCreateCommand());
        Button sequenceReorderUp = this.getWidgetFactory().createButton(buttonComp, "", 132);
        sequenceReorderUp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        sequenceReorderUp.addListener(13, e -> this.executeMoveCommand(true));
        Button sequenceReorderDown = this.getWidgetFactory().createButton(buttonComp, "", 1028);
        sequenceReorderDown.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        sequenceReorderDown.addListener(13, e -> this.executeMoveCommand(false));
        Button sequenceDelete = this.getWidgetFactory().createButton(buttonComp, "", 8);
        sequenceDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        sequenceDelete.addListener(13, e -> this.executeDeleteCommand());
    }

    private void executeCreateCommand() {
        Object selection = ((TreeSelection)this.sequencesViewer.getSelection()).getFirstElement();
        if (selection instanceof ServiceSequence) {
            ServiceSequence serSeq = (ServiceSequence)selection;
            this.executeCommand((Command)new CreateServiceSequenceCommand(this.getType().getService(), serSeq));
        } else if (selection instanceof ServiceTransaction) {
            ServiceTransaction serTran = (ServiceTransaction)selection;
            this.executeCommand((Command)new CreateTransactionCommand(serTran.getServiceSequence()));
        } else if (selection instanceof OutputPrimitive) {
            OutputPrimitive op = (OutputPrimitive)selection;
            this.executeCommand((Command)new CreateOutputPrimitiveCommand(op.getServiceTransaction(), null, true));
        } else if (selection == null) {
            this.executeCommand((Command)new CreateServiceSequenceCommand(this.getType().getService()));
        }
        this.sequencesViewer.refresh();
    }

    private void executeMoveCommand(boolean moveUp) {
        Object selection = ((TreeSelection)this.sequencesViewer.getSelection()).getFirstElement();
        if (selection instanceof ServiceSequence) {
            ServiceSequence serSeq = (ServiceSequence)selection;
            this.executeCommand((Command)new ChangeServiceSequenceOrderCommand(serSeq, moveUp));
        } else if (selection instanceof ServiceTransaction) {
            ServiceTransaction serTran = (ServiceTransaction)selection;
            this.executeCommand((Command)new ChangeTransactionOrderCommand(serTran, moveUp));
        } else if (selection instanceof OutputPrimitive) {
            OutputPrimitive op = (OutputPrimitive)selection;
            this.executeCommand((Command)new ChangeOutputPrimitiveOrderCommand(op, moveUp));
        }
        this.sequencesViewer.refresh();
    }

    private void executeDeleteCommand() {
        Object selection = ((TreeSelection)this.sequencesViewer.getSelection()).getFirstElement();
        if (selection instanceof ServiceSequence) {
            ServiceSequence serSeq = (ServiceSequence)selection;
            this.executeCommand(new DeleteServiceSequenceCommand(this.getType(), serSeq));
        } else if (selection instanceof ServiceTransaction) {
            ServiceTransaction serTran = (ServiceTransaction)selection;
            this.executeCommand(new DeleteTransactionCommand(serTran));
        } else if (selection instanceof OutputPrimitive) {
            OutputPrimitive op = (OutputPrimitive)selection;
            this.executeCommand(new DeleteOutputPrimitiveCommand(op));
        }
        this.sequencesViewer.refresh();
    }

    protected void performRefresh() {
        this.leftNameInput.setText(this.getType().getService().getLeftInterface() != null ? this.getType().getService().getLeftInterface().getName() : "");
        this.leftCommentInput.setText(this.getType().getService().getLeftInterface() != null && this.getType().getService().getLeftInterface().getComment() != null ? this.getType().getService().getLeftInterface().getComment() : "");
        this.rightNameInput.setText(this.getType().getService().getRightInterface() != null ? this.getType().getService().getRightInterface().getName() : "");
        this.rightCommentInput.setText(this.getType().getService().getRightInterface() != null && this.getType().getService().getRightInterface().getComment() != null ? this.getType().getService().getRightInterface().getComment() : "");
        this.sequencesViewer.setInput((Object)this.getType().getService());
    }

    protected void setInputCode() {
        this.leftNameInput.setEnabled(false);
        this.leftCommentInput.setEnabled(false);
        this.rightNameInput.setEnabled(false);
        this.rightCommentInput.setEnabled(false);
        this.sequencesViewer.setInput(null);
    }

    protected void setInputInit() {
    }

    private static Composite createButtonContainer(FormToolkit widgetFactory, Composite parent) {
        Composite container = widgetFactory.createComposite(parent, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, true);
        container.setLayoutData((Object)buttonCompLayoutData);
        container.setLayout((Layout)new GridLayout(1, true));
        return container;
    }
}

