/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class InterfaceElementSection
extends AbstractSection {
    private Text nameText;
    private Text commentText;
    protected CCombo typeCombo;
    private Text parameterText;
    private CLabel valueCLabel;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTypeAndCommentSection(parent);
    }

    protected void createTypeAndCommentSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.Name + ":");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)ChangeNameCommand.forName((INamedElement)this.getType(), (String)this.nameText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.Comment + ":");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.Type + ":");
        Composite typeComp = this.getWidgetFactory().createComposite(composite);
        typeComp.setLayout((Layout)new GridLayout(2, false));
        typeComp.setLayoutData((Object)new GridData(4, 0, true, false));
        this.typeCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)typeComp);
        this.typeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.typeCombo.addListener(13, event -> {
            ChangeDataTypeCommand cmd = null;
            if (this.getType() instanceof AdapterDeclaration) {
                AdapterType newType = this.getTypeLibrary().getAdapterTypeEntry(this.typeCombo.getText()).getType();
                cmd = this.newChangeTypeCommand((VarDeclaration)this.getType(), (DataType)newType);
            } else {
                IInterfaceElement iInterfaceElement = this.getType();
                if (iInterfaceElement instanceof VarDeclaration) {
                    VarDeclaration varDecl = (VarDeclaration)iInterfaceElement;
                    cmd = this.newChangeTypeCommand(varDecl, this.getDataTypeLib().getType(this.typeCombo.getText()));
                }
            }
            this.executeCommand((Command)cmd);
        });
        this.valueCLabel = this.getWidgetFactory().createCLabel(composite, FordiacMessages.InitialValue + ":");
        this.parameterText = this.createGroupText(composite, true);
        this.parameterText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeValueCommand((VarDeclaration)this.getType(), this.parameterText.getText()));
            this.addContentAdapter();
        });
    }

    private void fillTypeCombo(String text) {
        this.typeCombo.removeAll();
        if (this.getType() instanceof Event) {
            EventTypeLibrary.getInstance().getEventTypes().forEach(eType -> this.typeCombo.add(eType.getName()));
        } else if (this.getType() instanceof AdapterDeclaration) {
            this.getTypeLibrary().getAdapterTypesSorted().forEach(adp -> this.typeCombo.add(adp.getType().getName()));
        } else if (this.getType() instanceof VarDeclaration) {
            this.getDataTypeLib().getDataTypesSorted().forEach(dataType -> this.typeCombo.add(dataType.getName()));
        }
        if (this.typeCombo.getItems().length > 0) {
            this.typeCombo.setText(text);
        }
    }

    @Override
    protected void performRefresh() {
        this.setEditableFields(this.getType().getFBNetworkElement() instanceof SubApp);
        this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
        this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
        String itype = "";
        IInterfaceElement iInterfaceElement = this.getType();
        if (iInterfaceElement instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)iInterfaceElement;
            String string = itype = varDecl.getType() != null ? varDecl.getTypeName() : "";
            if (this.getType().isIsInput()) {
                this.parameterText.setVisible(true);
                this.valueCLabel.setVisible(true);
                this.parameterText.setText(varDecl.getValue() != null ? varDecl.getValue().getValue() : "");
            } else {
                this.valueCLabel.setVisible(false);
                this.parameterText.setVisible(false);
            }
        } else {
            itype = FordiacMessages.Event;
            this.valueCLabel.setVisible(false);
            this.parameterText.setVisible(false);
        }
        this.fillTypeCombo(itype);
    }

    private void setEditableFields(boolean editAble) {
        this.nameText.setEditable(editAble);
        this.nameText.setEnabled(editAble);
        this.commentText.setEditable(editAble);
        this.commentText.setEnabled(editAble);
        this.typeCombo.setEnabled(editAble && this.getType().getInputConnections().isEmpty() && this.getType().getOutputConnections().isEmpty());
    }

    protected ChangeDataTypeCommand newChangeTypeCommand(VarDeclaration data, DataType newType) {
        return ChangeDataTypeCommand.forDataType((IInterfaceElement)data, (DataType)newType);
    }

    protected IInterfaceElement getInputType(Object input) {
        Object objToCheck;
        if (input instanceof EditPart) {
            EditPart ep = (EditPart)input;
            v0 = ep.getModel();
        } else {
            v0 = objToCheck = input;
        }
        if (objToCheck instanceof IInterfaceElement) {
            IInterfaceElement ie = (IInterfaceElement)objToCheck;
            return ie;
        }
        if (input instanceof Value) {
            Value value = (Value)input;
            return value.getParentIE();
        }
        return null;
    }

    protected IInterfaceElement getType() {
        return (IInterfaceElement)this.type;
    }

    @Override
    protected void setInputInit() {
    }

    @Override
    protected void setInputCode() {
    }
}

