/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SysConfTemplateTransferDropTargetListener;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfPaletteFactory;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationContextMenueProvider;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditorInput;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.SystemConfEditPartFactory;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.ui.IEditorInput;

public class SystemConfigurationEditor
extends DiagramEditorWithFlyoutPalette {
    private SystemConfiguration sysConf;

    protected EditPartFactory getEditPartFactory() {
        return new SystemConfEditPartFactory((GraphicalEditor)this);
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new SystemConfigurationContextMenueProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry());
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new SysConfTemplateTransferDropTargetListener((EditPartViewer)this.getViewer(), this.getSystem());
    }

    public SystemConfiguration getModel() {
        return this.sysConf;
    }

    public void setInput(IEditorInput input) {
        SystemConfigurationEditorInput sysConfInput = this.checkEditorInput(input);
        this.sysConf = sysConfInput.getContent();
        super.setInput(input);
    }

    /*
     * WARNING - void declaration
     */
    private SystemConfigurationEditorInput checkEditorInput(IEditorInput input) {
        void sysConfEI;
        if (!(input instanceof SystemConfigurationEditorInput)) {
            throw new IllegalArgumentException("System configuration editors only accept SystemConfigurationEditorInput as valid inputs!");
        }
        SystemConfigurationEditorInput systemConfigurationEditorInput = (SystemConfigurationEditorInput)input;
        SystemConfigurationEditorInput currentEditorInput = (SystemConfigurationEditorInput)this.getEditorInput();
        if (currentEditorInput != null && currentEditorInput.getContent() != sysConfEI.getContent()) {
            throw new IllegalArgumentException("Editor input with new content given to system configuration editor. This is currently not supported!");
        }
        return sysConfEI;
    }

    public AutomationSystem getSystem() {
        return (AutomationSystem)this.sysConf.eContainer();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return SystemConfPaletteFactory.PALETTE_PREFERENCES;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.getModel() != null && this.getSystem() != null) {
            return SystemConfPaletteFactory.createPalette(this.getSystem());
        }
        return new PaletteRoot();
    }

    public void doSaveAs() {
    }

    public <T> T getAdapter(Class<T> type) {
        if (SystemConfiguration.class == type) {
            return type.cast(this.getModel());
        }
        return (T)super.getAdapter(type);
    }
}

