/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public class ArrayValueConverter<T>
implements ValueConverter<List<T>> {
    static final Pattern ARRAY_BEGIN_PATTERN = Pattern.compile("\\G\\[\\s*+");
    static final Pattern ARRAY_END_PATTERN = Pattern.compile("\\G\\s*+\\]");
    static final Pattern ARRAY_SEPARATOR_PATTERN = Pattern.compile("\\G\\s*+,\\s*+");
    static final Pattern ARRAY_REPEAT_BEGIN_PATTERN = Pattern.compile("\\G(\\d++)\\s*+\\(");
    static final Pattern ARRAY_REPEAT_END_PATTERN = Pattern.compile("\\G\\)");
    private final ValueConverter<T> elementValueConverter;

    public ArrayValueConverter(ValueConverter<T> elementValueConverter) {
        this.elementValueConverter = elementValueConverter;
    }

    @Override
    public String toString(List<T> value) {
        return value.stream().map(this.elementValueConverter::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public List<T> toValue(String string) throws IllegalArgumentException {
        return this.toValue(new Scanner(string));
    }

    @Override
    public List<T> toValue(Scanner scanner) throws IllegalArgumentException {
        ArrayList<T> result = new ArrayList<T>();
        if (scanner.findWithinHorizon(ARRAY_BEGIN_PATTERN, 0) == null) {
            throw new IllegalArgumentException(Messages.VALIDATOR_ARRAY_MISSES_BRACKETS);
        }
        do {
            if (scanner.findWithinHorizon(ARRAY_REPEAT_BEGIN_PATTERN, 0) != null) {
                result.addAll(this.parseRepeatSyntax(scanner, result.size()));
                continue;
            }
            result.add(this.parseValue(scanner, result.size()));
        } while (scanner.findWithinHorizon(ARRAY_SEPARATOR_PATTERN, 0) != null);
        if (scanner.findWithinHorizon(ARRAY_END_PATTERN, 0) == null) {
            throw new IllegalArgumentException(Messages.VALIDATOR_ARRAY_MISSES_BRACKETS);
        }
        return result;
    }

    private List<T> parseRepeatSyntax(Scanner scanner, int index) throws NumberFormatException, IllegalArgumentException {
        int count = Integer.parseInt(scanner.match().group(1));
        ArrayList result = new ArrayList();
        do {
            if (scanner.findWithinHorizon(ARRAY_REPEAT_BEGIN_PATTERN, 0) != null) {
                this.parseRepeatSyntax(scanner, index + result.size());
                continue;
            }
            result.add(this.parseValue(scanner, index + result.size()));
        } while (scanner.findWithinHorizon(ARRAY_SEPARATOR_PATTERN, 0) != null);
        if (scanner.findWithinHorizon(ARRAY_REPEAT_END_PATTERN, 0) == null) {
            throw new IllegalArgumentException(Messages.ArrayValueConverter_InvalidRepeatSyntax);
        }
        return IntStream.range(0, count).mapToObj(unused -> result).flatMap(Collection::stream).toList();
    }

    private T parseValue(Scanner scanner, int index) {
        try {
            return this.elementValueConverter.toValue(scanner);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ArrayValueConverter_IllegalElementValue, index), e);
        }
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), this.elementValueConverter);
    }
}

