/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.Inject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalPriorities;
import org.eclipse.xtext.ui.editor.contentassist.IProposalConflictHelper;

public abstract class AbstractCompletionProposalFactory
implements ICompletionProposalFactory {
    @Inject
    private IContentProposalPriorities priorities;
    @Inject
    private IProposalConflictHelper conflictHelper;

    public ICompletionProposal createCompletionProposal(String proposal, String displayString, Image image, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, new StyledString(displayString), image, this.getPriorityHelper().getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    public void setConflictHelper(IProposalConflictHelper conflictHelper) {
        this.conflictHelper = conflictHelper;
    }

    public IProposalConflictHelper getConflictHelper() {
        return this.conflictHelper;
    }

    public void setPriorityHelper(IContentProposalPriorities priorities) {
        this.priorities = priorities;
    }

    public IContentProposalPriorities getPriorityHelper() {
        return this.priorities;
    }

    protected ICompletionProposal createCompletionProposal(String proposal, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, null, null, this.getPriorityHelper().getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    @Override
    public ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, displayString, image, this.getPriorityHelper().getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, int priority, String prefix, ContentAssistContext context) {
        if (this.isValidProposal(proposal, prefix, context)) {
            return this.doCreateProposal(proposal, displayString, image, priority, context);
        }
        return null;
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        if (proposal == null) {
            return false;
        }
        if (!context.getMatcher().isCandidateMatchingPrefix(proposal, prefix)) {
            return false;
        }
        return !this.conflictHelper.existsConflict(proposal, context);
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, StyledString displayString, Image image, int replacementOffset, int replacementLength) {
        return new ConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, proposal.length(), image, displayString, null, null);
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        ConfigurableCompletionProposal result = this.doCreateProposal(proposal, displayString, image, replacementOffset, replacementLength);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(this.getReplacementContextLength(context));
        return result;
    }

    protected int getReplacementContextLength(ContentAssistContext context) {
        return context.getReplaceContextLength();
    }
}

