/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.views;

import java.util.List;
import org.eclipse.fordiac.ide.model.StructTreeNode;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.views.StructParser;
import org.eclipse.fordiac.ide.monitoring.views.WatchValueTreeNode;

public final class WatchValueTreeNodeUtils {
    public static final String ASSIGN = ":=";
    public static final String CLAMP_OP = "(";
    public static final String CLAMP_CL = ")";
    public static final String DELIMITER = ",";

    public static String decorateHexValue(String value, DataType type, MonitoringElement model) {
        if (WatchValueTreeNodeUtils.isHexDecoractionNecessary(value, type)) {
            return WatchValueTreeNodeUtils.decorateHexNumber(value);
        }
        if (WatchValueTreeNodeUtils.isStruct(type)) {
            WatchValueTreeNode dbgStruct = StructParser.createStructFromString(value, (StructuredType)type, model, new WatchValueTreeNode(model));
            WatchValueTreeNodeUtils.adaptAnyBitValues(dbgStruct.getChildren());
            return WatchValueTreeNodeUtils.buildTreeString(dbgStruct);
        }
        return value;
    }

    public static boolean isHexDecoractionNecessary(String value, DataType type) {
        return WatchValueTreeNodeUtils.isHexValue(type) && WatchValueTreeNodeUtils.isNumeric(value);
    }

    public static void adaptAnyBitValues(List<StructTreeNode> childrens) {
        for (StructTreeNode structTreeNode : childrens) {
            if (structTreeNode.hasChildren()) {
                WatchValueTreeNodeUtils.adaptAnyBitValues(structTreeNode.getChildren());
            }
            VarDeclaration structTreeNodeVar = structTreeNode.getVariable();
            WatchValueTreeNode watchedValueTreeNode = (WatchValueTreeNode)structTreeNode;
            if (structTreeNodeVar == null || !WatchValueTreeNodeUtils.isHexDecoractionNecessary(watchedValueTreeNode.getValue(), structTreeNodeVar.getType())) continue;
            watchedValueTreeNode.setValue(WatchValueTreeNodeUtils.decorateHexNumber(watchedValueTreeNode.getValue()));
        }
    }

    public static String decorateHexNumber(String value) {
        long parseInt;
        try {
            parseInt = Long.parseUnsignedLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            parseInt = 0L;
        }
        return WatchValueTreeNodeUtils.convertIntegerToHexString(parseInt);
    }

    private static String buildTreeString(WatchValueTreeNode dbgStruct) {
        return String.valueOf(WatchValueTreeNodeUtils.buildSubTreeString(dbgStruct.getChildren(), CLAMP_OP)) + CLAMP_CL;
    }

    private static String buildSubTreeString(List<StructTreeNode> list, String valString) {
        for (StructTreeNode tn : list) {
            WatchValueTreeNode wtn = (WatchValueTreeNode)tn;
            if (wtn.hasChildren()) {
                valString = String.valueOf(valString) + wtn.getPinName() + ASSIGN + CLAMP_OP;
                valString = String.valueOf(valString) + WatchValueTreeNodeUtils.buildSubTreeString(wtn.getChildren(), valString) + CLAMP_CL + DELIMITER;
                continue;
            }
            if (wtn.getVariable() == null) continue;
            valString = String.valueOf(valString) + wtn.getVariable().getName() + ASSIGN + wtn.getValue() + DELIMITER;
        }
        return valString.substring(0, valString.length() - 1);
    }

    private static boolean isStruct(DataType type) {
        return type instanceof StructuredType;
    }

    private static String convertIntegerToHexString(long number) {
        return "16#" + Long.toHexString(number).toUpperCase();
    }

    private static boolean isNumeric(String input) {
        return input.chars().allMatch(Character::isDigit);
    }

    private static boolean isHexValue(DataType type) {
        return type instanceof AnyBitType && !(type instanceof BoolType);
    }
}

