/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.views;

import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.StructTreeNode;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.views.StructParser;

public class WatchValueTreeNode
extends StructTreeNode {
    private String value;
    private String varName;
    private final StructuredType structType;
    private final MonitoringBaseElement monitoringBaseElement;

    public WatchValueTreeNode(MonitoringBaseElement monitoringBaseElement) {
        this.structType = null;
        this.monitoringBaseElement = monitoringBaseElement;
    }

    public WatchValueTreeNode(MonitoringBaseElement monitoringBaseElement, StructuredType structType) {
        this.structType = structType;
        this.monitoringBaseElement = monitoringBaseElement;
    }

    public WatchValueTreeNode(MonitoringBaseElement monitoringBaseElement, StructuredType structType, String varName, String value, VarDeclaration variable, WatchValueTreeNode parent) {
        this.structType = structType;
        this.monitoringBaseElement = monitoringBaseElement;
        this.varName = varName;
        this.value = value;
        this.variable = variable;
        this.parent = parent;
        this.root = parent.root;
    }

    public WatchValueTreeNode addChild(MonitoringBaseElement monitoringBaseElement) {
        WatchValueTreeNode node = WatchValueTreeNode.createNode(monitoringBaseElement, this);
        if (node != null) {
            this.children.add(node);
        }
        return node;
    }

    public static WatchValueTreeNode createNode(MonitoringBaseElement monitoringBaseElement, WatchValueTreeNode root) {
        DataType type = monitoringBaseElement.getPort().getInterfaceElement().getType();
        WatchValueTreeNode node = null;
        if (monitoringBaseElement instanceof MonitoringElement) {
            MonitoringElement monitoringElement = (MonitoringElement)monitoringBaseElement;
            if (type instanceof StructuredType && type != IecTypes.GenericTypes.ANY_STRUCT) {
                node = WatchValueTreeNode.createStructNode(monitoringBaseElement, type, root);
            } else if (type != IecTypes.GenericTypes.ANY_STRUCT) {
                node = WatchValueTreeNode.createVariableNode(monitoringElement);
            }
        }
        return node;
    }

    private static WatchValueTreeNode createVariableNode(MonitoringElement monitoringElement) {
        return new WatchValueTreeNode(monitoringElement);
    }

    public static WatchValueTreeNode createStructNode(MonitoringBaseElement monitoringBaseElement, DataType type, WatchValueTreeNode parent) {
        if (monitoringBaseElement instanceof MonitoringElement && !((MonitoringElement)monitoringBaseElement).isOffline() && !((MonitoringElement)monitoringBaseElement).getCurrentValue().equals("N/A")) {
            return WatchValueTreeNode.createOnlineNode(monitoringBaseElement, type, parent);
        }
        return WatchValueTreeNode.createOfflineNode(monitoringBaseElement, type, parent);
    }

    public static WatchValueTreeNode createOfflineNode(MonitoringBaseElement monitoringBaseElement, DataType type, WatchValueTreeNode parent) {
        String pinName = ((MonitoringElement)monitoringBaseElement).getPort().getInterfaceElement().getName();
        WatchValueTreeNode structRoot = new WatchValueTreeNode(monitoringBaseElement, (StructuredType)type, "", pinName, null, parent);
        StructParser.buildTree((StructuredType)type, structRoot, monitoringBaseElement);
        return structRoot;
    }

    public static WatchValueTreeNode createOnlineNode(MonitoringBaseElement monitoringBaseElement, DataType type, WatchValueTreeNode parent) {
        String currentValue = ((MonitoringElement)monitoringBaseElement).getCurrentValue();
        return StructParser.createStructFromString(currentValue, (StructuredType)type, (MonitoringElement)monitoringBaseElement, parent);
    }

    public WatchValueTreeNode addChildBase(MonitoringBaseElement monitoringBaseElement) {
        String portString;
        WatchValueTreeNode treeNode = new WatchValueTreeNode(monitoringBaseElement);
        treeNode.varName = portString = monitoringBaseElement.getPort().getPortString();
        this.children.add(treeNode);
        return treeNode;
    }

    public void addChild(WatchValueTreeNode child) {
        this.children.add(child);
    }

    public StructTreeNode addChild(VarDeclaration memberVariable, MonitoringBaseElement element, StructuredType type) {
        WatchValueTreeNode treeNode = new WatchValueTreeNode(element, type, memberVariable.getName(), null, memberVariable, this);
        this.children.add(treeNode);
        return treeNode;
    }

    public MonitoringBaseElement getMonitoringBaseElement() {
        return this.monitoringBaseElement;
    }

    public String getWatchedElementString() {
        if (this.isStructLeaf() || this.isStructNode() && !this.isStructRootNode()) {
            return this.varName != null ? this.varName : "N/A";
        }
        if (this.monitoringBaseElement instanceof MonitoringElement) {
            return ((MonitoringElement)this.monitoringBaseElement).getPortString();
        }
        return "N/A";
    }

    public String getValue() {
        if (!this.isStructNode() && this.monitoringBaseElement instanceof MonitoringElement) {
            return ((MonitoringElement)this.monitoringBaseElement).getCurrentValue();
        }
        if (this.isStructRootNode() && this.monitoringBaseElement instanceof MonitoringElement) {
            return ((MonitoringElement)this.monitoringBaseElement).getCurrentValue();
        }
        if (this.isStructLeaf()) {
            return this.value != null ? this.value : "N/A";
        }
        if (this.isStructNode()) {
            return "";
        }
        return "N/A";
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isStructRootNode() {
        return this.structType != null && this.parent == this.root;
    }

    public boolean isStructNode() {
        return this.structType != null;
    }

    public boolean isStructLeaf() {
        return !this.hasChildren() && this.isStructNode();
    }
}

