/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.handlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseFactory;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.AdapterPortElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringAdapterElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringFactory;
import org.eclipse.fordiac.ide.model.monitoring.SubAppPortElement;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.Messages;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.MonitoringManagerUtils;
import org.eclipse.fordiac.ide.monitoring.editparts.MonitoringAdapterInterfaceEditPart;
import org.eclipse.fordiac.ide.monitoring.handlers.AbstractMonitoringHandler;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddWatchHandler
extends AbstractMonitoringHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            MonitoringManager manager = MonitoringManager.getInstance();
            Set<IInterfaceElement> foundElements = AddWatchHandler.getSelectedWatchedElements(manager, (StructuredSelection)selection);
            for (IInterfaceElement ie : foundElements) {
                this.createElementFromPort(manager, ie);
            }
            this.refreshEditor();
            MonitoringManager.getInstance().notifyWatchesChanged();
        }
        return null;
    }

    public void createElementFromPort(MonitoringManager manager, IInterfaceElement ie) {
        PortElement port = MonitoringManagerUtils.createPortElement(ie);
        if (AddWatchHandler.validatePort(port, ie)) {
            this.createMonitoringElement(manager, port);
        }
    }

    private static boolean validatePort(PortElement port, IInterfaceElement ie) {
        if (port instanceof SubAppPortElement && ((SubAppPortElement)port).getAnchor() == null) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.MonitoringManagerUtils_NoSubappAnchor, ie.getName()));
            return false;
        }
        return true;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            this.setBaseEnabled(!AddWatchHandler.getSelectedWatchedElements(MonitoringManager.getInstance(), (StructuredSelection)selection).isEmpty());
        } else {
            this.setBaseEnabled(false);
        }
    }

    private static Set<IInterfaceElement> getSelectedWatchedElements(MonitoringManager manager, StructuredSelection selection) {
        HashSet<IInterfaceElement> foundElements = new HashSet<IInterfaceElement>();
        for (Object selectedObject : selection) {
            IInterfaceElement ie;
            if (!(selectedObject instanceof EditPart) || selectedObject instanceof MonitoringAdapterInterfaceEditPart) continue;
            Object model = ((EditPart)selectedObject).getModel();
            if (model instanceof FBNetworkElement) {
                if (!MonitoringManagerUtils.canBeMonitored((FBNetworkElement)model)) continue;
                foundElements.addAll((Collection<IInterfaceElement>)((FBNetworkElement)model).getInterface().getAllInterfaceElements());
                continue;
            }
            if (!(model instanceof IInterfaceElement) || !MonitoringManagerUtils.canBeMonitored(ie = (IInterfaceElement)model, false) || manager.containsPort(ie)) continue;
            foundElements.add(ie);
        }
        return foundElements;
    }

    protected MonitoringBaseElement createMonitoringElement(MonitoringManager manager, PortElement port) {
        Object element = port instanceof AdapterPortElement ? MonitoringFactory.eINSTANCE.createMonitoringAdapterElement() : (port instanceof SubAppPortElement ? AddWatchHandler.createSubappElement(port, manager) : MonitoringFactory.eINSTANCE.createMonitoringElement());
        element.setPort(port);
        if (!manager.containsPort(port.getInterfaceElement())) {
            manager.addMonitoringElement((MonitoringBaseElement)element);
        }
        if (port instanceof AdapterPortElement) {
            Object adpaterElement = element;
            this.createMonitoringElementsForAdapterInterface(manager, (MonitoringAdapterElement)adpaterElement);
        }
        return element;
    }

    public static MonitoringBaseElement createSubappElement(PortElement port, MonitoringManager manager) {
        SubappMonitoringElement element = MonitoringFactory.eINSTANCE.createSubappMonitoringElement();
        MonitoringElement anchor = MonitoringFactory.eINSTANCE.createMonitoringElement();
        PortElement anchorPort = MonitoringManagerUtils.createPortElement(((SubAppPortElement)port).getAnchor());
        anchor.setPort(anchorPort);
        element.setAnchor(anchor);
        MonitoringBaseElement monitoringElement = manager.getMonitoringElement(anchorPort.getInterfaceElement());
        if (monitoringElement == null) {
            manager.addMonitoringElement(anchor);
        } else {
            element.setAnchor(monitoringElement);
        }
        return element;
    }

    private void createMonitoringElementsForAdapterInterface(MonitoringManager manager, MonitoringAdapterElement adpaterElement) {
        AddWatchHandler.createMonitoredAdpaterFBView(adpaterElement);
        this.refreshEditor();
        PortElement port = adpaterElement.getPort();
        EList<MonitoringElement> childElements = adpaterElement.getElements();
        InterfaceList interfaceList = adpaterElement.getMonitoredAdapterFB().getInterface();
        EList<PortElement> ports = ((AdapterPortElement)port).getPorts();
        ArrayList ios = new ArrayList();
        ios.addAll(interfaceList.getEventInputs());
        ios.addAll(interfaceList.getEventOutputs());
        ios.addAll(interfaceList.getInputVars());
        ios.addAll(interfaceList.getOutputVars());
        for (IInterfaceElement io : ios) {
            PortElement newPort = MonitoringBaseFactory.eINSTANCE.createPortElement();
            newPort.setFb(port.getFb());
            newPort.setInterfaceElement(io);
            newPort.setResource(port.getResource());
            newPort.getHierarchy().addAll((Collection)port.getHierarchy());
            ports.add(newPort);
            childElements.add((MonitoringElement)this.createMonitoringElement(manager, newPort));
        }
    }

    private static void createMonitoredAdpaterFBView(MonitoringAdapterElement adpaterElement) {
        AdapterFB fb = LibraryElementFactory.eINSTANCE.createAdapterFB();
        AdapterDeclaration interfaceElement = (AdapterDeclaration)adpaterElement.getPort().getInterfaceElement();
        AdapterTypePaletteEntry entry = interfaceElement.getPaletteEntry();
        fb.setPaletteEntry((PaletteEntry)entry);
        fb.setAdapterDecl(interfaceElement);
        fb.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        AddWatchHandler.createMonitoredAdapterInterface(fb);
        adpaterElement.setMonitoredAdapterFB(fb);
    }

    private static void createMonitoredAdapterInterface(AdapterFB fb) {
        InterfaceList interfaceList = fb.getInterface();
        for (Event event : fb.getType().getInterfaceList().getEventInputs()) {
            interfaceList.getEventInputs().add((Object)((Event)EcoreUtil.copy((EObject)event)));
        }
        for (Event event : fb.getType().getInterfaceList().getEventOutputs()) {
            interfaceList.getEventOutputs().add((Object)((Event)EcoreUtil.copy((EObject)event)));
        }
        for (VarDeclaration inVar : fb.getType().getInterfaceList().getInputVars()) {
            interfaceList.getInputVars().add((Object)((VarDeclaration)EcoreUtil.copy((EObject)inVar)));
        }
        for (VarDeclaration outVar : fb.getType().getInterfaceList().getOutputVars()) {
            interfaceList.getOutputVars().add((Object)((VarDeclaration)EcoreUtil.copy((EObject)outVar)));
        }
    }
}

