/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.DeviceMonitoringHandler;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.jface.operation.IRunnableWithProgress;

class EnableSystemMonitoringRunnable
implements IRunnableWithProgress {
    private final SystemMonitoringData systemMonitoringData;

    public EnableSystemMonitoringRunnable(SystemMonitoringData systemMonitoringData) {
        this.systemMonitoringData = systemMonitoringData;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        EList devices = this.systemMonitoringData.getSystem().getSystemConfiguration().getDevices();
        int count = devices.size() * 2;
        monitor.beginTask("Enable monitoring for system", count += this.systemMonitoringData.getMonitoredElements().size());
        this.connectToDevices((List<Device>)devices, monitor);
        this.addWatches(monitor);
        this.startPollingThreads(monitor);
        monitor.done();
    }

    private void connectToDevices(List<Device> devices, IProgressMonitor monitor) {
        monitor.subTask("Connecting to the devices");
        for (Device dev : devices) {
            if (monitor.isCanceled()) break;
            IDeviceManagementInteractor devMgmInteractor = this.getDevMgmInteractor(dev);
            try {
                devMgmInteractor.connect();
            }
            catch (DeploymentException e) {
                this.systemMonitoringData.removeDeviceMonitoringHandler(dev);
                Activator.getDefault().logError("Monitoring: Cannot connect to device " + dev.getName(), (Exception)((Object)e));
            }
            monitor.worked(1);
        }
    }

    private void addWatches(IProgressMonitor monitor) {
        monitor.subTask("Adding the watches");
        for (MonitoringBaseElement element : this.systemMonitoringData.getMonitoredElements()) {
            if (monitor.isCanceled()) break;
            if (!(element instanceof MonitoringElement)) continue;
            monitor.subTask("Add watch for: " + element.getPortString());
            this.systemMonitoringData.sendAddWatch(element);
            monitor.worked(1);
        }
    }

    private void startPollingThreads(IProgressMonitor monitor) {
        monitor.subTask("Enabling the polling threads");
        for (Map.Entry<Device, DeviceMonitoringHandler> runner : this.systemMonitoringData.getDevMonitoringHandlers().entrySet()) {
            if (monitor.isCanceled()) break;
            runner.getValue().enable();
            monitor.worked(1);
        }
    }

    private IDeviceManagementInteractor getDevMgmInteractor(Device dev) {
        return this.getOrCreateDevMonitoringHandler(dev).getDevMgmInteractor();
    }

    private DeviceMonitoringHandler getOrCreateDevMonitoringHandler(Device dev) {
        DeviceMonitoringHandler retVal = this.systemMonitoringData.getDevMonitoringHandler(dev);
        if (retVal == null) {
            retVal = new DeviceMonitoringHandler(dev, this.systemMonitoringData);
            this.systemMonitoringData.addDevMonitoringHandler(dev, retVal);
        }
        return retVal;
    }
}

