/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.DeviceMonitoringHandler;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.jface.operation.IRunnableWithProgress;

class DisableSystemMonitoringRunnable
implements IRunnableWithProgress {
    private final SystemMonitoringData systemMonitoringData;

    public DisableSystemMonitoringRunnable(SystemMonitoringData systemMonitoringData) {
        this.systemMonitoringData = systemMonitoringData;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        EList devices = this.systemMonitoringData.getSystem().getSystemConfiguration().getDevices();
        int count = devices.size() * 2;
        monitor.beginTask("Disable monitoring for system", count += this.systemMonitoringData.getMonitoredElements().size());
        this.stopPollingThreads(monitor);
        this.removeWatches(monitor);
        this.disconnectFromDevices(monitor);
        monitor.done();
    }

    private void disconnectFromDevices(IProgressMonitor monitor) {
        monitor.subTask("Disconnecting the devices");
        for (Map.Entry<Device, DeviceMonitoringHandler> runner : this.systemMonitoringData.getDevMonitoringHandlers().entrySet()) {
            if (monitor.isCanceled()) break;
            try {
                if (runner.getValue().getDevMgmInteractor().isConnected()) {
                    runner.getValue().getDevMgmInteractor().disconnect();
                }
            }
            catch (DeploymentException e) {
                Activator.getDefault().logError("Could not disconnect from device", (Exception)((Object)e));
            }
            monitor.worked(1);
        }
        this.systemMonitoringData.getDevMonitoringHandlers().clear();
    }

    private void removeWatches(IProgressMonitor monitor) {
        monitor.subTask("Connecting to the devices");
        for (MonitoringBaseElement element : this.systemMonitoringData.getMonitoredElements()) {
            if (monitor.isCanceled()) break;
            if (!(element instanceof MonitoringElement)) continue;
            monitor.subTask("Remove watch for: " + element.getPortString());
            this.systemMonitoringData.sendRemoveWatch(element);
            ((MonitoringElement)element).setCurrentValue("");
            monitor.worked(1);
        }
    }

    private void stopPollingThreads(IProgressMonitor monitor) {
        monitor.subTask("Enabling the polling threads");
        for (Map.Entry<Device, DeviceMonitoringHandler> runner : this.systemMonitoringData.getDevMonitoringHandlers().entrySet()) {
            if (monitor.isCanceled()) break;
            runner.getValue().disable();
            monitor.worked(1);
        }
    }
}

