/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.runtime.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.fordiac.ide.runtime.Activator;
import org.eclipse.fordiac.ide.runtime.IRuntimeLauncher;
import org.eclipse.fordiac.ide.runtime.LaunchParameter;
import org.eclipse.fordiac.ide.runtime.LaunchRuntimeException;
import org.eclipse.fordiac.ide.runtime.views.RuntimeModifyListener;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RuntimeLauncherView {
    private FormToolkit toolkit;
    private final List<IRuntimeLauncher> launchers;
    private final Map<String, Combo> comboTable = new HashMap<String, Combo>();

    @Inject
    public RuntimeLauncherView() {
        this.launchers = RuntimeLauncherView.loadRuntimeLaunchers();
    }

    @PostConstruct
    public void postConstruct(Composite parent, MPart part) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        Form form = this.toolkit.createForm(parent);
        form.getBody().setLayout((Layout)new GridLayout(1, true));
        form.setText("Launch Simulated Devices");
        this.launchers.forEach(launcher -> this.createRuntimeLauncherGroupUI(form.getBody(), (IRuntimeLauncher)launcher));
        this.initFields(part);
    }

    @Persist
    void save(MPart part) {
        Map persistedState = part.getPersistedState();
        for (IRuntimeLauncher launcher : this.launchers) {
            for (LaunchParameter param : launcher.getParams()) {
                if (param.isFixedValues()) continue;
                String launchParamID = RuntimeLauncherView.getLaunchParamID(launcher, param);
                persistedState.put(launchParamID, Arrays.deepToString(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getItems()));
            }
        }
    }

    private void initFields(MPart part) {
        Map persistedState = part.getPersistedState();
        for (IRuntimeLauncher launcher : this.launchers) {
            for (LaunchParameter param : launcher.getParams()) {
                if (!param.isFixedValues()) {
                    this.configureDynamicParam(persistedState, launcher, param);
                }
                this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).select(0);
            }
        }
    }

    private void configureDynamicParam(Map<String, String> persistedState, IRuntimeLauncher launcher, LaunchParameter param) {
        String launchParamID = RuntimeLauncherView.getLaunchParamID(launcher, param);
        String text = persistedState.get(launchParamID);
        if (text != null) {
            String[] data;
            Combo combo = this.comboTable.get(launchParamID);
            text = text.substring(1, text.length() - 1);
            String[] stringArray = data = text.split(",");
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                String temp = element.trim();
                if (!Arrays.asList(combo.getItems()).contains(temp)) {
                    combo.add(temp);
                }
                ++n2;
            }
        }
    }

    private void createRuntimeLauncherGroupUI(Composite parent, IRuntimeLauncher launcher) {
        Group launcherGroup = new Group(parent, 4);
        this.toolkit.adapt((Composite)launcherGroup);
        launcherGroup.setText(launcher.getName());
        launcherGroup.setLayout((Layout)new GridLayout(3, false));
        launcherGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        List<LaunchParameter> params = launcher.getParams();
        boolean launchButton = true;
        int j = 0;
        while (j < launcher.getNumParameters()) {
            Label paramName = this.toolkit.createLabel((Composite)launcherGroup, params.get(j).getName(), 64);
            int style = 2048;
            if (params.get(j).isFixedValues()) {
                style |= 8;
            }
            Combo paramValue = new Combo((Composite)launcherGroup, style);
            this.toolkit.adapt((Control)paramValue, true, true);
            if (params.get(j).isFixedValues()) {
                int k = 0;
                while (k < params.get(j).getValues().length) {
                    String deviceString = params.get(j).getValues()[k];
                    paramValue.add(deviceString);
                    ++k;
                }
            } else {
                paramValue.add(params.get(j).getValue());
            }
            GridData textAreaData = new GridData();
            textAreaData.horizontalAlignment = 4;
            textAreaData.grabExcessHorizontalSpace = true;
            paramValue.setLayoutData((Object)textAreaData);
            paramValue.addModifyListener((ModifyListener)new RuntimeModifyListener(launcher, paramName.getText()){

                @Override
                public void modifyText(ModifyEvent e) {
                    this.getLauncher().setParam(this.getName(), ((Combo)e.getSource()).getText());
                }
            });
            this.comboTable.put(String.valueOf(launcher.getName()) + "." + paramName.getText(), paramValue);
            if (launchButton) {
                this.createLaunchButton(launcher, launcherGroup);
                launchButton = false;
            }
            ++j;
        }
        this.createConfiguredRuntimeUI(launcher, (Composite)launcherGroup);
    }

    private void createConfiguredRuntimeUI(IRuntimeLauncher launcher, Composite parent) {
        Composite configuredRuntimeComposite = this.toolkit.createComposite(parent);
        configuredRuntimeComposite.setLayout((Layout)new RowLayout());
        configuredRuntimeComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.toolkit.createLabel(configuredRuntimeComposite, "Currently configured runtime: ", 0);
        Link configuredRuntimePathLabel = new Link(configuredRuntimeComposite, 0);
        this.toolkit.adapt((Control)configuredRuntimePathLabel, false, false);
        RuntimeLauncherView.setRuntimePathLink(launcher, configuredRuntimePathLabel);
        configuredRuntimePathLabel.addListener(13, ev -> {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)launcher.getPathPreferenceSettingPageID(), (String[])new String[]{launcher.getPathPreferenceSettingPageID(), "org.eclipse.fordiac.ide.preferences.FordiacPreferencePage"}, null);
            dialog.open();
        });
        launcher.addPathPreferenceChangeListener(ev -> Display.getDefault().asyncExec(() -> {
            if (!configuredRuntimeComposite.isDisposed()) {
                RuntimeLauncherView.setRuntimePathLink(launcher, configuredRuntimePathLabel);
                configuredRuntimeComposite.getParent().layout();
            }
        }));
    }

    private static void setRuntimePathLink(IRuntimeLauncher launcher, Link configuredRuntimePathLabel) {
        configuredRuntimePathLabel.setText("<a>" + RuntimeLauncherView.getRuntimePath(launcher) + "</a>");
    }

    private static String getRuntimePath(IRuntimeLauncher launcher) {
        String path = launcher.getRuntimePath();
        if (path.length() == 0) {
            path = MessageFormat.format("No runtime configured for {0}. Click here for setting it up.", launcher.getName());
        }
        return path;
    }

    private void createLaunchButton(IRuntimeLauncher launcher, Group launcherGroup) {
        Button launchButton = new Button((Composite)launcherGroup, 64);
        launchButton.setText("Launch " + launcher.getName());
        GridData launchButtonData = new GridData();
        launchButtonData.verticalSpan = launcher.getNumParameters();
        launchButtonData.verticalAlignment = 4;
        launchButtonData.horizontalAlignment = 4;
        launchButton.setLayoutData((Object)launchButtonData);
        launchButton.addListener(13, event -> {
            try {
                launcher.launch();
                for (LaunchParameter param : launcher.getParams()) {
                    if (Arrays.asList(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getItems()).contains(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getText())) continue;
                    this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).add(this.comboTable.get(RuntimeLauncherView.getLaunchParamID(launcher, param)).getText(), 0);
                }
            }
            catch (LaunchRuntimeException e1) {
                Activator.getDefault().logError(e1.getMessage(), e1);
            }
        });
    }

    private static String getLaunchParamID(IRuntimeLauncher launcher, LaunchParameter param) {
        return String.valueOf(launcher.getName()) + "." + param.getName();
    }

    private static List<IRuntimeLauncher> loadRuntimeLaunchers() {
        IConfigurationElement[] elems = RuntimeLauncherView.getRuntimeLaunchers();
        ArrayList<IRuntimeLauncher> retVal = new ArrayList<IRuntimeLauncher>(elems.length);
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IRuntimeLauncher) {
                    IRuntimeLauncher launcher = (IRuntimeLauncher)object;
                    retVal.add(launcher);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError("Error loading run-time launcher", (Exception)((Object)corex));
            }
            ++n2;
        }
        return retVal;
    }

    private static IConfigurationElement[] getRuntimeLaunchers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.runtime", "RuntimeLauncher");
        Arrays.sort(elems, (element1, element2) -> {
            String order1 = element1.getAttribute("order");
            String order2 = element2.getAttribute("order");
            if (order1 == null) {
                return order2 == null ? 0 : 1;
            }
            if (order2 == null) {
                return -1;
            }
            return order1.compareTo(order2);
        });
        return elems;
    }
}

