/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.signing.GpgConfigurationException;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class CommitOperation
implements IEGitOperation {
    private static final Pattern LEADING_WHITESPACE = Pattern.compile("^[\\h\\v]+");
    Collection<String> commitFileList;
    private boolean commitWorkingDirChanges = false;
    private final String author;
    private final String committer;
    private final String message;
    private boolean amending = false;
    private boolean commitAll = false;
    private boolean sign = false;
    private Repository repo;
    Collection<String> notTracked;
    private boolean createChangeId;
    private boolean commitIndex;
    RevCommit commit = null;

    public CommitOperation(IFile[] filesToCommit, Collection<IFile> notTracked, String author, String committer, String message) throws CoreException {
        this.author = author;
        this.committer = committer;
        this.message = this.stripLeadingWhitespace(message);
        if (filesToCommit != null && filesToCommit.length > 0) {
            this.setRepository(filesToCommit[0]);
        }
        if (filesToCommit != null) {
            this.commitFileList = this.buildFileList(Arrays.asList(filesToCommit));
        }
        if (notTracked != null) {
            this.notTracked = this.buildFileList(notTracked);
        }
    }

    public CommitOperation(Repository repository, Collection<String> filesToCommit, Collection<String> notTracked, String author, String committer, String message) throws CoreException {
        this.repo = repository;
        this.author = author;
        this.committer = committer;
        this.message = this.stripLeadingWhitespace(message);
        if (filesToCommit != null) {
            this.commitFileList = new HashSet<String>(filesToCommit);
        }
        if (notTracked != null) {
            this.notTracked = new HashSet<String>(notTracked);
        }
    }

    public CommitOperation(Repository repository, String author, String committer, String message) throws CoreException {
        this.repo = repository;
        this.author = author;
        this.committer = committer;
        this.message = this.stripLeadingWhitespace(message);
        this.commitIndex = true;
    }

    private String stripLeadingWhitespace(String text) {
        return text == null ? "" : LEADING_WHITESPACE.matcher(text).replaceFirst("");
    }

    private void setRepository(IFile file) throws CoreException {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
        if (mapping == null) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitOperation_couldNotFindRepositoryMapping, (Object)file), null));
        }
        this.repo = mapping.getRepository();
    }

    public void setRepository(Repository repository) {
        this.repo = repository;
    }

    private Collection<String> buildFileList(Collection<IFile> files) throws CoreException {
        HashSet<String> result = new HashSet<String>();
        for (IFile file : files) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
            if (mapping == null) {
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitOperation_couldNotFindRepositoryMapping, (Object)file), null));
            }
            String repoRelativePath = mapping.getRepoRelativePath((IResource)file);
            result.add(repoRelativePath);
        }
        return result;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                if (CommitOperation.this.commitAll) {
                    CommitOperation.this.commitAll();
                } else if (CommitOperation.this.amending || CommitOperation.this.commitFileList != null && CommitOperation.this.commitFileList.size() > 0 || CommitOperation.this.commitIndex) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor);
                    progress.setTaskName(CoreText.CommitOperation_PerformingCommit);
                    CommitOperation.this.addUntracked();
                    CommitOperation.this.commit();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    private void addUntracked() throws CoreException {
        if (this.notTracked == null || this.notTracked.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(this.repo);){
                AddCommand addCommand = git.add();
                boolean fileAdded = false;
                for (String path : this.notTracked) {
                    if (!this.commitFileList.contains(path)) continue;
                    addCommand.addFilepattern(path);
                    fileAdded = true;
                }
                if (fileAdded) {
                    addCommand.call();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repo);
    }

    private void commit() throws TeamException {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (Git git = new Git(this.repo);){
                CommitCommand commitCommand = git.commit();
                this.setAuthorAndCommitter(commitCommand);
                commitCommand.setAmend(this.amending).setMessage(this.message).setInsertChangeId(this.createChangeId);
                if (!this.commitIndex) {
                    for (String path : this.commitFileList) {
                        commitCommand.setOnly(path);
                    }
                }
                this.commit = commitCommand.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GpgConfigurationException e) {
            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
        }
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public void setCommitAll(boolean commitAll) {
        this.commitAll = commitAll;
    }

    public void setComputeChangeId(boolean createChangeId) {
        this.createChangeId = createChangeId;
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    private void commitAll() throws TeamException {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (Git git = new Git(this.repo);){
                CommitCommand commitCommand = git.commit();
                this.setAuthorAndCommitter(commitCommand);
                this.commit = commitCommand.setAll(true).setMessage(this.message).setInsertChangeId(this.createChangeId).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JGitInternalException e) {
            throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void setAuthorAndCommitter(CommitCommand commitCommand) throws TeamException {
        File gpg;
        RepositoryUtil repoUtil;
        RevCommit headCommit;
        PersonIdent authorIdent;
        PersonIdent enteredCommitter;
        PersonIdent enteredAuthor;
        TimeZone timeZone;
        Date commitDate;
        block16: {
            commitDate = new Date();
            timeZone = TimeZone.getDefault();
            enteredAuthor = RawParseUtils.parsePersonIdent((String)this.author);
            enteredCommitter = RawParseUtils.parsePersonIdent((String)this.committer);
            if (enteredAuthor == null) {
                throw new TeamException(NLS.bind((String)CoreText.CommitOperation_errorParsingPersonIdent, (Object)this.author));
            }
            if (enteredCommitter == null) {
                throw new TeamException(NLS.bind((String)CoreText.CommitOperation_errorParsingPersonIdent, (Object)this.committer));
            }
            if (this.repo.getRepositoryState().equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED)) {
                try {
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try (RevWalk rw = new RevWalk(this.repo);){
                        ObjectId cherryPickHead = this.repo.readCherryPickHead();
                        authorIdent = rw.parseCommit((AnyObjectId)cherryPickHead).getAuthorIdent();
                        break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Activator.logError(CoreText.CommitOperation_ParseCherryPickCommitFailed, e);
                    throw new IllegalStateException(e);
                }
            }
            authorIdent = new PersonIdent(enteredAuthor, commitDate, timeZone);
        }
        PersonIdent committerIdent = new PersonIdent(enteredCommitter, commitDate, timeZone);
        if (this.amending && (headCommit = (repoUtil = RepositoryUtil.getInstance()).parseHeadCommit(this.repo)) != null) {
            PersonIdent headAuthor = headCommit.getAuthorIdent();
            authorIdent = new PersonIdent(enteredAuthor, headAuthor.getWhen(), headAuthor.getTimeZone());
        }
        commitCommand.setAuthor(authorIdent);
        commitCommand.setCommitter(committerIdent);
        commitCommand.setSign(this.sign ? Boolean.TRUE : Boolean.FALSE);
        if (this.sign && (gpg = GitSettings.getGpgExecutable()) != null) {
            GpgConfig cfg = new GpgConfig((Config)this.repo.getConfig()){

                public String getProgram() {
                    return gpg.getAbsolutePath();
                }
            };
            commitCommand.setGpgConfig(cfg);
        }
    }

    static /* synthetic */ boolean access$6(CommitOperation commitOperation) {
        return commitOperation.commitWorkingDirChanges;
    }
}

