/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.xtext;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.IAlgorithmEditor;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.ui.providers.SourceViewerColorProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;

public class XTextAlgorithmEditor
implements IAlgorithmEditor {
    private final EmbeddedEditor editor;
    private final EmbeddedEditorModelAccess embeddedEditorModelAccess;
    private final BaseFBType fbType;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (8 != notification.getEventType() && !(notification.getNotifier() instanceof Algorithm)) {
                Display.getDefault().asyncExec(() -> {
                    if (XTextAlgorithmEditor.this.editor.getViewer() != null && XTextAlgorithmEditor.this.editor.getViewer().getControl() != null && !XTextAlgorithmEditor.this.editor.getViewer().getControl().isDisposed()) {
                        XTextAlgorithmEditor.this.updatePrefix();
                    }
                });
            }
        }
    };
    private int prefixLineCount = 0;
    private boolean documentValid = true;

    public XTextAlgorithmEditor(EmbeddedEditor editor, BaseFBType fbType) {
        this.editor = editor;
        this.fbType = fbType;
        this.embeddedEditorModelAccess = this.editor.createPartialEditor("", "", "", true);
        SourceViewerColorProvider.initializeSourceViewerColors((ISourceViewer)this.getViewer());
        this.getViewer().addVerticalRulerColumn((IVerticalRulerColumn)this.createLineNumberRulerColumn());
        AbstractRulerColumn column = new AbstractRulerColumn(){};
        this.getViewer().addVerticalRulerColumn((IVerticalRulerColumn)column);
        this.fbType.eAdapters().add((Object)this.adapter);
        editor.getViewer().getControl().addDisposeListener(e -> {
            boolean bl = this.getFBType().eAdapters().remove((Object)this.adapter);
        });
        this.updatePrefix();
    }

    private LineNumberRulerColumn createLineNumberRulerColumn() {
        LineNumberRulerColumn lnrc = new LineNumberRulerColumn(){

            protected String createDisplayString(int line) {
                return super.createDisplayString(line -= XTextAlgorithmEditor.this.prefixLineCount);
            }
        };
        lnrc.setForeground(this.getViewer().getTextWidget().getForeground());
        lnrc.setBackground(this.getViewer().getTextWidget().getBackground());
        return lnrc;
    }

    protected BaseFBType getFBType() {
        return this.fbType;
    }

    private XtextSourceViewer getViewer() {
        return this.editor.getViewer();
    }

    @Override
    public void addDocumentListener(IDocumentListener listener) {
        this.editor.getDocument().addDocumentListener(listener);
    }

    @Override
    public void removeDocumentListener(IDocumentListener listener) {
        this.editor.getDocument().removeDocumentListener(listener);
    }

    @Override
    public void setAlgorithmText(String text) {
        this.embeddedEditorModelAccess.updateModel(this.regeneratePrefix(), text, "");
    }

    @Override
    public String getAlgorithmText() {
        return this.embeddedEditorModelAccess.getEditablePart();
    }

    @Override
    public Control getControl() {
        return this.getViewer().getControl();
    }

    private void updatePrefix() {
        this.documentValid = false;
        this.embeddedEditorModelAccess.updatePrefix(this.regeneratePrefix());
        try {
            this.prefixLineCount = this.getViewer().getDocument().getNumberOfLines(0, this.getViewer().getVisibleRegion().getOffset());
            --this.prefixLineCount;
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        this.documentValid = true;
    }

    protected String regeneratePrefix() {
        return "";
    }

    @Override
    public boolean isDocumentValid() {
        return this.documentValid;
    }
}

