/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.xtext;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.IAlgorithmEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.IAlgorithmEditorCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.xtext.XTextAlgorithmEditor;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class XTextAlgorithmCreator
implements IAlgorithmEditorCreator {
    private static final String LINKING_FILE_EXTENSION = "xtextfbt";
    @Inject
    private EmbeddedEditorFactory editorFactory;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    @Named(value="file.extensions")
    private String fileExtension;

    @Override
    public IAlgorithmEditor createAlgorithmEditor(Composite parent, final BaseFBType fbType) {
        IEditedResourceProvider resourceProvider = new IEditedResourceProvider(){

            public XtextResource createResource() {
                XtextResourceSet resourceSet = (XtextResourceSet)XTextAlgorithmCreator.this.resourceSetProvider.get();
                Resource fbResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, XTextAlgorithmCreator.LINKING_FILE_EXTENSION));
                fbResource.getContents().add((Object)fbType);
                fbType.getInterfaceList().getSockets().forEach(adp -> this.createAdapterResource(resourceSet, (AdapterDeclaration)adp));
                fbType.getInterfaceList().getPlugs().forEach(adp -> this.createAdapterResource(resourceSet, (AdapterDeclaration)adp));
                if (fbType.getTypeLibrary() != null) {
                    this.createStructResources(resourceSet, fbType.getTypeLibrary().getDataTypeLibrary().getStructuredTypes());
                }
                return (XtextResource)resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, XTextAlgorithmCreator.this.fileExtension));
            }

            private void createStructResources(XtextResourceSet resourceSet, List<StructuredType> structuredTypes) {
                structuredTypes.forEach(struct -> {
                    Resource structResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, XTextAlgorithmCreator.LINKING_FILE_EXTENSION));
                    structResource.getContents().add(struct);
                });
            }

            private void createAdapterResource(XtextResourceSet resourceSet, AdapterDeclaration adapter) {
                if (adapter.getType() != null && adapter.getType().getAdapterFBType() != null) {
                    Resource adapterResource = resourceSet.createResource(this.computeUnusedUri((ResourceSet)resourceSet, XTextAlgorithmCreator.LINKING_FILE_EXTENSION));
                    adapterResource.getContents().add((Object)adapter.getType().getAdapterFBType());
                }
            }

            protected URI computeUnusedUri(ResourceSet resourceSet, String fileExtension) {
                int i = 0;
                while (i < Integer.MAX_VALUE) {
                    URI syntheticUri = URI.createURI((String)("__synthetic" + i + "." + fileExtension));
                    if (resourceSet.getResource(syntheticUri, false) == null) {
                        return syntheticUri;
                    }
                    ++i;
                }
                throw new IllegalStateException();
            }
        };
        EmbeddedEditor editor = this.editorFactory.newEditor(resourceProvider).showErrorAndWarningAnnotations().withParent(parent);
        return this.createXTextAlgorithmEditor(fbType, editor);
    }

    protected XTextAlgorithmEditor createXTextAlgorithmEditor(BaseFBType fbType, EmbeddedEditor editor) {
        return new XTextAlgorithmEditor(editor, fbType);
    }
}

