/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.AbstractChangeAlgorithmTypeCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeAlgorithmTextCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.IAlgorithmEditor;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.IAlgorithmEditorCreator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties.ECCSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AlgorithmEditingComposite {
    private CLabel languageLabel;
    private CCombo languageCombo;
    private CLabel commentLabel;
    private Text commentText;
    private Composite codeEditors;
    private final StackLayout stack;
    private final Map<String, IAlgorithmEditor> editors = new HashMap<String, IAlgorithmEditor>();
    private IAlgorithmEditor currentAlgEditor;
    private CommandStack commandStack;
    private Algorithm currentAlgorithm;
    private boolean blockUpdates = false;
    private final IDocumentListener listener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            if (AlgorithmEditingComposite.this.getAlgorithm() != null && AlgorithmEditingComposite.this.currentAlgEditor != null && AlgorithmEditingComposite.this.currentAlgEditor.isDocumentValid()) {
                AlgorithmEditingComposite.this.executeCommand(new ChangeAlgorithmTextCommand((TextAlgorithm)AlgorithmEditingComposite.this.getAlgorithm(), AlgorithmEditingComposite.this.currentAlgEditor.getAlgorithmText()));
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    protected AlgorithmEditingComposite() {
        this.stack = new StackLayout();
    }

    public void createControls(Composite parent, FormToolkit toolkit) {
        Composite langAndComments = toolkit.createComposite(parent);
        langAndComments.setLayout((Layout)new GridLayout(4, false));
        langAndComments.setLayoutData((Object)new GridData(4, 0, true, false));
        this.languageLabel = new CLabel(langAndComments, 0);
        this.languageLabel.setBackground(parent.getBackground());
        this.languageLabel.setText(Messages.AlgorithmComposite_Language);
        this.languageCombo = ComboBoxWidgetFactory.createCombo((Composite)langAndComments);
        this.fillLanguageDropDown();
        this.languageCombo.addListener(13, event -> {
            AbstractChangeAlgorithmTypeCommand changeAlgorithmTypeCommand = this.getChangeAlgorithmTypeCommand(this.getFBType(), this.getAlgorithm(), this.languageCombo.getText());
            this.executeCommand(changeAlgorithmTypeCommand);
            this.setAlgorithm(changeAlgorithmTypeCommand.getNewAlgorithm());
        });
        this.commentLabel = new CLabel(langAndComments, 0);
        this.commentLabel.setBackground(parent.getBackground());
        this.commentLabel.setText(Messages.AlgorithmComposite_Comment);
        this.commentText = toolkit.createText(langAndComments, "", 2052);
        this.commentText.setEditable(true);
        this.commentText.setEnabled(true);
        this.commentText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.commentText.addListener(24, e -> this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getAlgorithm(), this.commentText.getText())));
        GridData codeEditorsGridData = new GridData(4, 4, true, true);
        codeEditorsGridData.horizontalSpan = 1;
        codeEditorsGridData.minimumHeight = 250;
        this.codeEditors = new Group(parent, 32);
        this.codeEditors.setBackground(toolkit.getColors().getBackground());
        this.codeEditors.setForeground(toolkit.getColors().getForeground());
        toolkit.adapt(this.codeEditors);
        this.codeEditors.setLayout((Layout)this.stack);
        this.codeEditors.setLayoutData((Object)codeEditorsGridData);
        this.disableAllFields();
    }

    protected BaseFBType getFBType() {
        return (BaseFBType)this.currentAlgorithm.eContainer();
    }

    protected Algorithm getAlgorithm() {
        return this.currentAlgorithm;
    }

    protected void executeCommand(Command cmd) {
        if (this.currentAlgorithm != null && this.getCommandStack() != null) {
            this.blockUpdates = true;
            this.getCommandStack().execute(cmd);
            this.blockUpdates = false;
        }
    }

    public void initialize(BaseFBType fbType, CommandStack commandStack) {
        this.setCommandStack(commandStack);
        this.loadEditors(fbType);
    }

    private void loadEditors(BaseFBType basicFBType) {
        IExtension[] extensions;
        this.editors.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.fordiac.ide.fbtypeeditor.ecc.algorithmEditor");
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                Object obj = null;
                try {
                    obj = element.createExecutableExtension("class");
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                if (obj instanceof IAlgorithmEditorCreator) {
                    IAlgorithmEditor editor = ((IAlgorithmEditorCreator)obj).createAlgorithmEditor(this.codeEditors, basicFBType);
                    String lang = element.getAttribute("language");
                    this.editors.put(lang, editor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void setAlgorithm(Algorithm algorithm) {
        if (!this.blockUpdates) {
            CommandStack commandStackBuffer = this.getCommandStack();
            this.setCommandStack(null);
            if (this.currentAlgorithm != algorithm) {
                this.currentAlgorithm = algorithm;
                if (this.currentAlgorithm != null) {
                    this.initializeEditor();
                    this.enableAllFields();
                } else {
                    this.stack.topControl = null;
                    this.codeEditors.layout();
                    this.disableAllFields();
                }
            }
            this.updateAlgFields();
            this.setCommandStack(commandStackBuffer);
        }
    }

    protected void enableAllFields() {
        this.languageLabel.setEnabled(true);
        this.commentLabel.setEnabled(true);
        this.commentText.setEnabled(true);
        this.languageCombo.setEnabled(true);
    }

    protected void disableAllFields() {
        this.languageLabel.setEnabled(false);
        this.commentLabel.setEnabled(false);
        this.commentText.setEnabled(false);
        this.languageCombo.setEnabled(false);
    }

    protected void updateAlgFields() {
        Algorithm alg = this.getAlgorithm();
        this.commentText.setText(alg != null ? alg.getComment() : "");
        this.languageCombo.select(alg != null ? this.languageCombo.indexOf(AlgorithmEditingComposite.getAlgorithmTypeString(this.getAlgorithm())) : 0);
        if (alg instanceof TextAlgorithm) {
            this.currentAlgEditor.setAlgorithmText(((TextAlgorithm)alg).getText());
        }
    }

    private void initializeEditor() {
        if (this.currentAlgEditor != null) {
            this.currentAlgEditor.removeDocumentListener(this.listener);
        }
        String algType = AlgorithmEditingComposite.getAlgorithmTypeString(this.getAlgorithm());
        this.currentAlgEditor = this.editors.get(algType);
        if (this.currentAlgEditor != null) {
            this.stack.topControl = this.currentAlgEditor.getControl();
            this.currentAlgEditor.addDocumentListener(this.listener);
        }
        this.codeEditors.layout();
    }

    protected static String getAlgorithmTypeString(Algorithm algorithm) {
        if (algorithm instanceof STAlgorithm) {
            return "ST";
        }
        if (algorithm instanceof TextAlgorithm) {
            return "AnyText";
        }
        return "AnyText";
    }

    protected void fillLanguageDropDown() {
        this.languageCombo.removeAll();
        for (String alg : ECCSection.getLanguages()) {
            this.languageCombo.add(alg);
        }
    }

    protected abstract AbstractChangeAlgorithmTypeCommand getChangeAlgorithmTypeCommand(BaseFBType var1, Algorithm var2, String var3);

    private CommandStack getCommandStack() {
        return this.commandStack;
    }

    private void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public Composite getCodeEditors() {
        return this.codeEditors;
    }
}

