/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteECStateCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithm;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEvent;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECTransitionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.figures.ECStateFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.ECStateLayoutEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.ECStateSelectionPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.TransitionNodeEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.VerifyListener;

public class ECStateEditPart
extends AbstractDirectEditableEditPart
implements NodeEditPart {
    private List<Object> stateChildren;
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (8 != notification.getEventType()) {
                Object feature = notification.getFeature();
                if (!(LibraryElementPackage.eINSTANCE.getECAction_Algorithm().equals(feature) || LibraryElementPackage.eINSTANCE.getECAction_Output().equals(feature) || LibraryElementPackage.eINSTANCE.getECState().equals(feature))) {
                    ECStateEditPart.this.refreshStateTooltip();
                    ECStateEditPart.this.refresh();
                }
            }
        }
    };
    private final IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getProperty().equals("ECCEditorStateColor")) {
            this.getNameLabel().setBackgroundColor(PreferenceGetter.getColor("ECCEditorStateColor"));
        }
        if (event.getProperty().equals("ECCEditorStateTextColor")) {
            this.getNameLabel().setForegroundColor(PreferenceGetter.getColor("ECCEditorStateTextColor"));
            this.getFigure().getLine().setForegroundColor(PreferenceGetter.getColor("ECCEditorStateTextColor"));
        }
    };

    public ECStateEditPart() {
        this.setConnectable(true);
    }

    private void refreshStateTooltip() {
        this.getFigure().getToolTip().setECState(this.getModel());
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.adapter);
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.adapter);
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public IFigure getContentPane() {
        return this.getFigure().getContentPane();
    }

    public List<Object> getCurrentChildren() {
        return this.stateChildren;
    }

    protected List<Object> getModelChildren() {
        if (this.stateChildren == null) {
            this.stateChildren = new ArrayList<Object>();
        } else {
            this.stateChildren.clear();
        }
        for (ECAction ecAction : this.getModel().getECAction()) {
            this.stateChildren.add(new ECActionAlgorithm(ecAction));
            this.stateChildren.add(new ECActionOutputEvent(ecAction));
        }
        return this.stateChildren;
    }

    protected IFigure createFigure() {
        return new ECStateFigure(this.getModel());
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ECStateLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TransitionNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                if (!ECStateEditPart.this.getModel().getECC().getStart().equals(ECStateEditPart.this.getModel())) {
                    return new DeleteECStateCommand(ECStateEditPart.this.getModel());
                }
                return null;
            }
        });
        this.installEditPolicy("Highlight_IN_OUTS", (EditPolicy)new ECStateSelectionPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        super.performRequest(request);
    }

    public ECState getModel() {
        return (ECState)super.getModel();
    }

    protected void refreshVisuals() {
        Rectangle rect = new Rectangle(this.getModel().getPosition().asPoint(), new Dimension(-1, -1));
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)rect);
        this.getFigure().setHasAction(!this.getModel().getECAction().isEmpty());
        this.refreshStateTooltip();
        super.refreshVisuals();
    }

    protected List<ECTransition> getModelSourceConnections() {
        return this.getModel().getOutTransitions();
    }

    protected List<ECTransition> getModelTargetConnections() {
        return this.getModel().getInTransitions();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getTarget() != null && connection.getTarget().equals(connection.getSource())) {
            return new FixedAnchor((IFigure)this.getFigure().getNameLabel(), false);
        }
        return new ChopboxAnchor((IFigure)this.getFigure().getNameLabel());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure().getNameLabel());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getSource() != null && connection.getSource().equals(connection.getTarget())) {
            return new FixedAnchor((IFigure)this.getFigure().getNameLabel(), true);
        }
        return new ChopboxAnchor((IFigure)this.getFigure().getNameLabel());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure().getNameLabel());
    }

    public Label getNameLabel() {
        return this.getFigure().getNameLabel();
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    public void highlightTransitions(boolean highlight) {
        for (Object obj : this.getSourceConnections()) {
            if (!(obj instanceof ECTransitionEditPart)) continue;
            ((ECTransitionEditPart)((Object)obj)).highlight(highlight);
        }
        for (Object obj : this.getTargetConnections()) {
            if (!(obj instanceof ECTransitionEditPart)) continue;
            ((ECTransitionEditPart)((Object)obj)).highlight(highlight);
        }
    }

    protected DirectEditManager createDirectEditManager() {
        return new LabelDirectEditManager((GraphicalEditPart)this, this.getNameLabel(), (VerifyListener)new IdentifierVerifyListener());
    }

    public ECStateFigure getFigure() {
        return (ECStateFigure)super.getFigure();
    }
}

